/*
 * @(#)ClipTest.java	1.6 96/12/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Event;
import java.awt.Component;
import java.awt.Canvas;
import java.awt.Panel;
import java.awt.GridLayout;

public class ClipTest extends Applet {
    public void init() {
	resize(200, 200);
	setLayout(new GridLayout(0, 1));
	add(new ClipDrawCanvas());
	Panel p = new Panel();
	p.setLayout(new GridLayout(1, 0));
	p.add(new ClipOtherPanel(true, false));
	p.add(new ClipOtherPanel(true, true));
	add(p);
    }
}

class ClipDrawCanvas extends Canvas {
    public void paint(Graphics g) {
	int width = size().width / 2;
	int height = size().height;
	paintit(g, 0, 0, width, height, false);
	paintit(g, width, 0, width, height, true);
    }

    public void paintit(Graphics g,
			int x, int y, int width, int height,
			boolean useShape) {
	g.setColor(Color.black);
	g.fillRect(x, y, width, height);
	g.setColor(Color.white);
	g.fillRect(x + 10, y + 10, width-20, height-20);
	Graphics g2 = g.create(x + 20, y + 20, width-40, height-40);
	g2.setColor(Color.blue);
	g2.fillRect(-1000, -1000, 2000, 2000);
	g2.translate(10, 10);
	g2.setColor(Color.green);
	g2.fillRect(0, 0, width-40, height-40);
	g2.setColor(Color.red);
	for (int i = 0; i < 2; i++) {
	    for (int j = 0; j < 2; j++) {
		Shape clip = g2.getClip();
		g2.clipRect((i == 0) ? -width : width-60,
			    (j == 0) ? -height : height-60,
			    width+10, height+10);
		g2.fillRect(-1000, -1000, 2000, 2000);
		if (useShape) {
		    g2.setClip(clip);
		} else {
		    Rectangle r = clip.getBounds();
		    g2.setClip(r.x, r.y, r.width, r.height);
		}
	    }
	}
	g2.dispose();
    }
}

class ClipOtherPanel extends Panel {
    boolean ignoreClip;

    Component c1, c2;

    ClipOtherPanel(boolean doChildren, boolean ignoreClip) {
	this.ignoreClip = ignoreClip;
	setLayout(null);
	if (doChildren) {
	    setBackground(Color.blue);
	    c1 = new ClipOtherPanel(false, ignoreClip);
	    c1.setBackground(Color.green);
	    add(c1);
	    c2 = new ClipOtherPanel(false, ignoreClip);
	    c2.setBackground(Color.red);
	    add(c2);
	}
    }

    public Color randomColor() {
	int r = (int) (Math.random() * 255);
	int g = (int) (Math.random() * 255);
	int b = (int) (Math.random() * 255);
	return new Color(r, g, b);
    }

    public void update(Graphics g) {
	paint(g);
    }

    public void paint(Graphics g) {
	if (ignoreClip) {
	    g.setClip(-1000, -1000, 2000, 2000);
	}
	g.setColor(randomColor());
	g.fillRect(-1000, -1000, 2000, 2000);
    }

    public void reshape(int x, int y, int width, int height) {
	super.reshape(x, y, width, height);
	int cw = 2 * width / 5;
	int ch = 2 * height / 5;
	if (c1 != null) {
	    c1.reshape(width / 5, height / 5, cw, ch);
	}
	if (c2 != null) {
	    c2.reshape(2 * width / 5, 2 * height / 5, cw, ch);
	}
    }

    public boolean mouseDown(Event evt, int x, int y) {
	repaint();
	return true;
    }
}
