/*
 * @(#)ClipboardTest.java	1.5 97/01/17
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.awt.datatransfer.*;
import java.applet.*;
import java.io.*;

public class ClipboardTest extends TestApplet implements ClipboardOwner {
    TextArea srcText;
    TextArea dstText;

    Button copyButton;
    Button pasteStringButton;
    Button pasteCharsButton;

    public void init() {

	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();

	setLayout(gridbag);

	srcText = new TextArea(8, 32);
	srcText.append("The quick brown fox jumps over the lazy dog.");
	c.gridwidth = 2;
	c.anchor = GridBagConstraints.CENTER;
	gridbag.setConstraints(srcText, c);
	add(srcText);

	copyButton = new Button("Copy Above");
	c.gridy = 0;
	c.gridy = 1;
	c.gridwidth = 1;
	gridbag.setConstraints(copyButton, c);
	add(copyButton);

	pasteStringButton = new Button("Paste String Below");
	pasteStringButton.disable();
	c.gridx = 1;
	gridbag.setConstraints(pasteStringButton, c);
	add(pasteStringButton);

	pasteCharsButton = new Button("Paste Chars Below");
	pasteCharsButton.disable();
	c.gridx = 2;
	gridbag.setConstraints(pasteCharsButton, c);
	add(pasteCharsButton);

	dstText = new TextArea(8, 32);
	c.gridx = 0;
	c.gridy = 2;
	c.gridwidth = 2;
	gridbag.setConstraints(dstText, c);
	add(dstText); 
    }

    public boolean action(Event evt, Object arg) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();

        if (evt.target == copyButton) {
	    String srcData = srcText.getText();
	    if (srcData != null) {
	        StringSelection contents = new StringSelection(srcData);
	        clipboard.setContents(contents, this);
		pasteStringButton.enable();
		pasteCharsButton.enable();
	    }
	    return true;

	} else if (evt.target == pasteCharsButton) {
	    Transferable content = clipboard.getContents(this);
	    if (content != null) {
	        try {
		    StringReader reader = (StringReader)(content.getTransferData(DataFlavor.plainTextFlavor));
		    char c[] = new char[100];
 		    reader.read(c, 0, 100);
		    String dstData = new String(c);
		    dstText.appendText(dstData);
		} catch (Exception e) {
		    print("Couldn't get clipboard contents in format: "+
			  DataFlavor.stringFlavor.getHumanPresentableName());	       
		}
	    }
	    return true;
	} else if (evt.target == pasteStringButton) {
	    Transferable content = clipboard.getContents(this);
	    if (content != null) {
	        try {
		    String dstData = (String)(content.getTransferData(DataFlavor.stringFlavor));
		    dstText.appendText(dstData);
		} catch (Exception e) {
		    print("Couldn't get clipboard contents in format: "+
			  DataFlavor.stringFlavor.getHumanPresentableName());	       
		}
	    }
	    return true;
	}
	return false;
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        System.out.println("Clipboard contents replaced");
    }

    public static void main(String[] args) {
        Frame f = new Frame("Clipboard Test");
        ClipboardTest test = new ClipboardTest();

	test.init();
	test.start();

	f.add("Center", test);
	f.pack();
	f.show();
    }

}
