/*
 * @(#)CursorTest.java	1.4 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.applet.Applet;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Container;
import java.awt.Canvas;
import java.awt.Panel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.BorderLayout;
import java.awt.GridLayout;

public class CursorTest extends Applet {
    public void init() {
	Container c;
	Container p = this;
	while (!(p instanceof Frame) && p.getParent() != null) {
	    p = p.getParent();
	}
	Frame f = (Frame) p;
	setLayout(new BorderLayout());
	add("North", c = new Panel());
	c.setLayout(new GridLayout(1, 3));
	c.add(new CursorCanvas(f, Frame.NW_RESIZE_CURSOR, Color.white));
	c.add(new CursorCanvas(f, Frame.N_RESIZE_CURSOR, Color.lightGray));
	c.add(new CursorCanvas(f, Frame.NE_RESIZE_CURSOR, Color.white));
	add("South", c = new Panel());
	c.setLayout(new GridLayout(1, 3));
	c.add(new CursorCanvas(f, Frame.SW_RESIZE_CURSOR, Color.white));
	c.add(new CursorCanvas(f, Frame.S_RESIZE_CURSOR, Color.lightGray));
	c.add(new CursorCanvas(f, Frame.SE_RESIZE_CURSOR, Color.white));
	add("East", c = new Panel());
	c.setLayout(new GridLayout(1, 1));
	c.add(new CursorCanvas(f, Frame.E_RESIZE_CURSOR, Color.lightGray));
	add("West", c = new Panel());
	c.setLayout(new GridLayout(1, 1));
	c.add(new CursorCanvas(f, Frame.W_RESIZE_CURSOR, Color.lightGray));
	add("Center", c = new Panel());
	c.setLayout(new GridLayout(2, 3));
	c.add(new CursorCanvas(f, Frame.DEFAULT_CURSOR, Color.red));
	c.add(new CursorCanvas(f, Frame.CROSSHAIR_CURSOR, Color.magenta));
	c.add(new CursorCanvas(f, Frame.TEXT_CURSOR, Color.blue));
	c.add(new CursorCanvas(f, Frame.WAIT_CURSOR, Color.yellow));
	c.add(new CursorCanvas(f, Frame.HAND_CURSOR, Color.green));
	c.add(new CursorCanvas(f, Frame.MOVE_CURSOR, Color.cyan));
	Dimension psize = preferredSize();
	Dimension size = size();
	if (psize.width < size.width || psize.height < size.height) {
	    resize(Math.max(psize.width, size.width),
		   Math.max(psize.height, size.height));
	}
    }
}

class CursorCanvas extends Canvas {
    static String cursornames[];

    static {
	cursornames = new String[14];
	cursornames[Frame.DEFAULT_CURSOR]   = "Default";
	cursornames[Frame.CROSSHAIR_CURSOR] = "Crosshair";
	cursornames[Frame.TEXT_CURSOR]      = "Text";
	cursornames[Frame.WAIT_CURSOR]      = "Wait";
	cursornames[Frame.SW_RESIZE_CURSOR] = "SW Resize";
	cursornames[Frame.SE_RESIZE_CURSOR] = "SE Resize";
	cursornames[Frame.NW_RESIZE_CURSOR] = "NW Resize";
	cursornames[Frame.NE_RESIZE_CURSOR] = "NE Resize";
	cursornames[Frame.N_RESIZE_CURSOR]  = "North Resize";
	cursornames[Frame.S_RESIZE_CURSOR]  = "South Resize";
	cursornames[Frame.W_RESIZE_CURSOR]  = "West Resize";
	cursornames[Frame.E_RESIZE_CURSOR]  = "East Resize";
	cursornames[Frame.HAND_CURSOR]      = "Hand";
	cursornames[Frame.MOVE_CURSOR]      = "Move";
    }

    int oldtype;
    int cursortype;
    String descriptor;
    Frame frame;

    public CursorCanvas(Frame f, int curnum, Color bg) {
	frame = f;
	oldtype = f.getCursorType();
	cursortype = curnum;
	descriptor = cursornames[curnum];
	setBackground(bg);
    }

    public void paint(Graphics g) {
	Dimension d = size();
	FontMetrics fm = g.getFontMetrics();
	int x = (d.width - fm.stringWidth(descriptor)) / 2;
	int y = ((d.height - fm.getHeight()) / 2) + fm.getAscent();
	g.drawString(descriptor, x, y);
    }

    public Dimension preferredSize() {
	return minimumSize();
    }

    public Dimension minimumSize() {
	FontMetrics fm = getFontMetrics(getFont());
	return new Dimension(fm.stringWidth(descriptor + "  "),
			     fm.getHeight() * 2);
    }

    public boolean mouseEnter(Event evt, int x, int y) {
        System.out.println(descriptor + " enter: x=" + x + ", y=" + y);
	frame.setCursor(cursortype);
	return true;
    }

    public boolean mouseExit(Event evt, int x, int y) {
        System.out.println(descriptor + " exit: x=" + x + ", y=" + y);
//	Windows mouse->window notification isn't ordered, so we can 
//	get the old window's mouseExit after the new window's mouseEnter.
//	frame.setCursor(oldtype);
	return true;
    }
}
