/*
 * @(#)CursorTest2.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;


class CursorPanel extends Panel {
    GridBagLayout gridbag = new GridBagLayout();

    void add(Component comp, GridBagConstraints c) {
	gridbag.setConstraints(comp, c);
	super.add(comp);
    }

    public CursorPanel() {
	Button button;
	Choice choice;
	Checkbox checkbox;
	TextField field;
	TextArea textarea;
	List list;
	Label label;

	GridBagConstraints c = new GridBagConstraints();	
	setLayout(gridbag);

	c.gridx = 0;
	c.gridy = 0;
	c.insets = new Insets(12,12,12,12);
	add(button = new Button("Crosshair"), c);
	button.setBackground(Color.lightGray);
	button.setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));

	c.gridx = 1;
	add(label = new Label("Wait"), c);
	label.setBackground(Color.lightGray);
	label.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

	c.gridx = 2;
	add(field = new TextField("Hand",10), c);
	field.setBackground(Color.lightGray);
	field.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));

	c.gridx = 0;
	c.gridy = 1;
	add(choice = new Choice(), c);
	choice.setBackground(Color.lightGray);
	choice.addItem("SouthWest Resize");
	choice.addItem("SouthEast Resize");
	choice.addItem("NorthEast Resize");
	choice.addItem("NorthWest Resize");
	choice.setCursor(Cursor.getPredefinedCursor(Cursor.SW_RESIZE_CURSOR));

	c.gridx = 1;
	add(checkbox = new Checkbox("Hand"), c);
	checkbox.setBackground(Color.lightGray);
	checkbox.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));

	c.gridx = 2;
	add(textarea = new TextArea(4,10), c);
	textarea.setBackground(Color.lightGray);
	textarea.setCursor(Cursor.getPredefinedCursor(Cursor.TEXT_CURSOR));

	c.gridx = 0;
	c.gridy = 2;
	add(list = new List(), c);
	list.setBackground(Color.lightGray);
	list.addItem("Text");
	list.addItem("Hand");
	list.addItem("Default");
	list.setCursor(Cursor.getPredefinedCursor(Cursor.TEXT_CURSOR));

	c.gridx = 1;
	add(list = new List(), c);
	list.setBackground(Color.lightGray);
	list.addItem("(Panel) Default");
	list.addItem("(Panel) Wait");
	list.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

	c.gridx = 2;
	add(list = new List(), c);
	list.setBackground(Color.lightGray);
	list.addItem("(Window) Default");
	list.addItem("(Window) Crosshair");
	
    }

    public boolean action(Event evt, Object arg) {
	Cursor cursor = null;
	Component comp = null;

	if (arg.equals("SouthWest Resize")) {
	    cursor = Cursor.getPredefinedCursor(Cursor.SW_RESIZE_CURSOR);
	} else if (arg.equals("SouthEast Resize")) {
	    cursor = Cursor.getPredefinedCursor(Cursor.SE_RESIZE_CURSOR);
	} else if (arg.equals("NorthEast Resize")) {
	    cursor = Cursor.getPredefinedCursor(Cursor.NE_RESIZE_CURSOR);
	} else if (arg.equals("NorthWest Resize")) {
	    cursor = Cursor.getPredefinedCursor(Cursor.NW_RESIZE_CURSOR);

	} else if (evt.target instanceof List) {
	    if (arg.equals("Text")) {
		cursor = Cursor.getPredefinedCursor(Cursor.TEXT_CURSOR);
	    } else if (arg.equals("Hand")) {
		cursor = Cursor.getPredefinedCursor(Cursor.HAND_CURSOR);
	    } else if (arg.equals("Default")) {
		cursor = Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR);
	    } else if (arg.equals("(Panel) Default")) {
		cursor = Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR);
		comp = this;
	    } else if (arg.equals("(Panel) Wait")) {
		cursor = Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR);
		comp = this;
	    } else if (arg.equals("(Window) Default")) {
		cursor = Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR);
		comp = this.getParent();
	    } else if (arg.equals("(Window) Crosshair")) {
		cursor = Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR);
		comp = this.getParent();
	    } 		
	}
	if (cursor != null) {
	    if (comp == null)
	        comp = (Component)evt.target;
	    if (comp.getCursor() != cursor) {
		comp.setCursor(cursor);
	    }
	    return true;
	}
	return false;
    }

}

class CursorFrame extends Frame {
    CursorDialog d, modal;

    public CursorFrame() {
	super("Cursor Test Frame");
	setLayout(new BorderLayout());
	add("North", new Label("This is north component of Dialog"));
	add("Center", new CursorPanel());
	add("South", new Label("This south component of Dialog"));
	MenuBar mb = new MenuBar();
	Menu m = new Menu("Windows");
	mb.add(m);
	m.add("Dialog");
	m.add("Modal Dialog");
	m.add("Window");
	setMenuBar(mb);
	pack();
    }

    public boolean action(Event evt, Object arg) {
	if (evt.target instanceof MenuItem) {
	    if (arg.equals("Dialog")) {
		if (d == null) {
		    d = new CursorDialog(this, false);
		}
		d.show();

	    } else if (arg.equals("Modal Dialog")) {
		if (modal == null) {
		   modal = new CursorDialog(this, true);
		}
		modal.show();
	    } else if (arg.equals("Window")) {
	
	    }
	    return true;
	}
	return false;
    }

    public boolean handleEvent(Event evt) {
	if (evt.id == Event.WINDOW_DESTROY) {
	    dispose();
	    return true;
	}
	return super.handleEvent(evt);
    }
}

class CursorDialog extends Dialog {

    public CursorDialog(Frame p, boolean modal) {
	super(p, "Cursor Test Dialog", modal);
	setLayout(new BorderLayout());
	add("North", new Label("This is north component of Window"));
	add("Center", new CursorPanel());
	add("South", new Label("This south component of Window"));
	pack();
    }

    public boolean handleEvent(Event evt) {
	if (evt.id == Event.WINDOW_DESTROY) {
	    hide();
	    return true;
	}
	return super.handleEvent(evt);
    }
}

public class CursorTest2 extends TestApplet {
    static final String POPUP_CMD = "Popup CursorFrame...";

    public void init() {
	setLayout(new BorderLayout());
	add("North", new Button(POPUP_CMD));
	add("Center", new CursorPanel());
	add("South", new Label("This is the south component of the applet panel"));
	show();
    }

    public boolean action(Event evt, Object arg) {
	if (arg.equals(POPUP_CMD)) {
	    CursorFrame f = new CursorFrame();
	    f.show();
	    return true;
	}
	return false;
    }

    public static void main(String[] args) {
	CursorFrame f = new CursorFrame();
	f.show();
    }	
}



