/*
 * @(#)DialogTest.java	1.7 96/12/06
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;


public class DialogTest extends TestApplet {
  DialogFrame1 df;

  public void init() {
    df = new DialogFrame1();
    df.pack();
    df.show();
  }

  public static void main() {
    Frame f = new Frame("DialogTest");
    DialogTest dt = new DialogTest();

    dt.init();
    dt.start();

    f.resize(200, 300);
    f.add("Center", dt);
    f.show();
  }
}


class DialogFrame1 extends Frame {
  Button b1, b2, b3;
  String s1 = "This is an error dialog";
  String s2 = "This is a save dialog with a title";
  ErrorDialog dialog1, dialog2;

  public DialogFrame1() {
    super("DialogFrame");
    b1 = new Button("Dialog1");
    b2 = new Button("Dialog2");
    b3 = new Button("Test Methods");

    setLayout(new FlowLayout());
    add(b1);
    add(b2);
    add(b3);
    pack();
  }

  public boolean handleEvent(Event evt) {
    if (evt.id == Event.ACTION_EVENT)
      if (evt.target == b1) {
	dialog1 = new ErrorDialog(s1, this, false);
        dialog1.show();
      }
      else if (evt.target == b2) {
	dialog2 = new ErrorDialog(s2, this, "TitledDialog", true);
	dialog2.show();
      }
      else dumpstatus();
    else return false;
    return true;
  }

  private void dumpstatus() {
    System.out.println("----- Dump Status ------");
    if (dialog1 != null) {
        System.out.println("dialog1.gettitle(): " + dialog1.getTitle());
        System.out.println("dialog1.isModal(): " + dialog1.isModal());
        System.out.println("dialog1.isResizable(): " + dialog1.isResizable());
        System.out.println("");
    }
    if (dialog2 != null) {
        System.out.println("dialog2.gettitle(): " + dialog2.getTitle());
        System.out.println("dialog2.isModal(): " + dialog2.isModal());
        System.out.println("dialog2.isResizable(): " + dialog2.isResizable());
    }
  }
}


class ErrorDialog extends Dialog {
  TextArea ta = new TextArea(3, 30);
  Button contbutton = new Button("Continue");
  Button nonresize, fliptitle;

  public ErrorDialog(String s, Frame f, boolean b) {
    super(f, b);
    Panel buttonpanel = new Panel();
    nonresize = new Button("NonResizable Dialog");
    fliptitle = new Button("FlipTitle");

    ta.setEditable(false);
    ta.insertText(s, 0);

    buttonpanel.setLayout(new FlowLayout());
    buttonpanel.add(contbutton);
    buttonpanel.add(nonresize);
    buttonpanel.add(fliptitle);
    
    setLayout(new BorderLayout());
    add("North", ta);
    add("South", buttonpanel);
    pack();
  }

  public ErrorDialog(String s, Frame f, String title, boolean b) {
    super(f, title, b);

    ta.setEditable(false);
    ta.insertText(s, 0);

    setLayout(new BorderLayout());
    add("North", ta);
    add("South", contbutton);
    pack();
  }

  public boolean handleEvent(Event evt) {
    if ((evt.id == Event.ACTION_EVENT) && (evt.target instanceof Button))
      if (evt.target == contbutton)
	dispose();
      else if (evt.target == nonresize)
	setResizable(false);
      else if (evt.target == fliptitle)
	setTitle("NewDialogTitle");
    else return false;
    return true;
  }
}
