/*
 * @(#)DrawTest.java	1.17 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;
import java.applet.*;

import java.util.Vector;

public class DrawTest extends TestApplet {
    public void init() {
	setLayout(new BorderLayout());
	DrawPanel dp = new DrawPanel();
	add("Center", dp);
	add("South",new DrawControls(dp));
    }

    public boolean handleEvent(Event e) {
	switch (e.id) {
	  case Event.WINDOW_DESTROY:
	    System.exit(0);
	    return true;
	  default:
	    return false;
	}
    }

    public static void main(String args[]) {
	Frame f = new Frame("DrawTest");
	DrawTest drawTest = new DrawTest();
	drawTest.init();
	drawTest.start();

	f.add("Center", drawTest);
	f.resize(300, 300);
	f.show();
    }
}

class DrawPanel extends Panel {
    public static final int LINES = 0;
    public static final int POINTS = 1;
    int	   mode = LINES;
    Vector lines = new Vector();
    Vector colors = new Vector();
    int x1,y1;
    int x2,y2;
    int xl = -1, yl;

    public DrawPanel() {
	setBackground(Color.white);
    }

    public void setDrawMode(int mode) {
	switch (mode) {
	  case LINES:
	  case POINTS:
	    this.mode = mode;
	    break;
	  default:
	    throw new IllegalArgumentException();
	}
    }

    public boolean handleEvent(Event e) {
	switch (e.id) {
	  case Event.MOUSE_DOWN:
	    switch (mode) {
	      case LINES:
		x1 = x2 = e.x;
		y1 = y2 = e.y;
		break;
	      case POINTS:
	      default:
		colors.addElement(getForeground());
		lines.addElement(new Rectangle(e.x, e.y, -1, -1));
		x1 = e.x;
		y1 = e.y;
		break;
	    }
	    repaint();
	    return true;
	  case Event.MOUSE_UP:
	    switch (mode) {
	      case LINES:
		colors.addElement(getForeground());
		lines.addElement(new Rectangle(x1, y1, e.x, e.y));
		x2 = -1;
		break;
	      case POINTS:
	      default:
		break;
	    }
	    repaint();
	    return true;
	  case Event.MOUSE_DRAG:
	    switch (mode) {
	      case LINES:
		x2 = e.x;
		y2 = e.y;
		break;
	      case POINTS:
	      default:
		colors.addElement(getForeground());
		lines.addElement(new Rectangle(x1, y1, e.x, e.y));
		x1 = e.x;
		y1 = e.y;
		break;
	    }
	    repaint();
	    return true;
	  case Event.WINDOW_DESTROY:
	    System.exit(0);
	    return true;
	  default:
	    return false;
	}
    }

    public void update(Graphics g) {
	if (mode == LINES && (xl != -1 || x2 != -1)) {
	    g.setColor(getForeground());
	    g.setXORMode(getBackground());
	    if (xl != -1) {
		/* erase the last line. */
		g.drawLine(x1, y1, xl, yl);
	    }
	    if (x2 != -1) {
		g.drawLine(x1, y1, x2, y2);
	    }
	    xl = x2;
	    yl = y2;
	}
	if (mode != LINES || x2 == -1) {
	    paint(g);
	}
    }

    public void paint(Graphics g) {
	int np = lines.size();

	/* draw the current lines */
	g.setColor(getForeground());
	g.setPaintMode();
	for (int i=0; i < np; i++) {
	    Rectangle p = (Rectangle)lines.elementAt(i);
	    g.setColor((Color)colors.elementAt(i));
	    if (p.width != -1) {
		g.drawLine(p.x, p.y, p.width, p.height);
	    } else {
		g.drawLine(p.x, p.y, p.x, p.y);
	    }
	}
    }
}


class DrawControls extends Panel {
    DrawPanel target;

    public DrawControls(DrawPanel target) {
	this.target = target;
	setLayout(new FlowLayout());
	setBackground(Color.lightGray);
	target.setForeground(Color.red);
	CheckboxGroup group = new CheckboxGroup();
	Checkbox b;
	add(b = new Checkbox(null, group, false));
	b.setBackground(Color.red);
	add(b = new Checkbox(null, group, false));
	b.setBackground(Color.green);
	add(b = new Checkbox(null, group, false));
	b.setBackground(Color.blue);
	add(b = new Checkbox(null, group, false));
	b.setBackground(Color.pink);
	add(b = new Checkbox(null, group, false));
	b.setBackground(Color.orange);
	add(b = new Checkbox(null, group, true));
	b.setBackground(Color.black);
	target.setForeground(b.getForeground());
	Choice shapes = new Choice();
	shapes.addItem("Lines");
	shapes.addItem("Points");
	shapes.setBackground(Color.lightGray);
	add(shapes);
    }

    public void paint(Graphics g) {
	Rectangle r = bounds();

	g.setColor(Color.lightGray);
	g.draw3DRect(0, 0, r.width, r.height, false);
    }

    public boolean action(Event e, Object arg) {
	if (e.target instanceof Checkbox) {
	    target.setForeground(((Component)e.target).getBackground());
	} else if (e.target instanceof Choice) {
	    String choice = (String)arg;

	    if (choice.equals("Lines")) {
		target.setDrawMode(DrawPanel.LINES);
	    } else if (choice.equals("Points")) {
		target.setDrawMode(DrawPanel.POINTS);
	    }
	}
	return true;
    }
}
	


    
