/*
 * @(#)EventTest.java	1.5 97/01/21
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

/**
 * A test of a Container with BorderLayout.
 */
public class EventTest extends TestApplet {
    public void init() {
	GridBagLayout gb = new GridBagLayout();
	GridBagConstraints cc;
	Component c;

	setLayout(gb);

	cc = new GridBagConstraints();
	cc.fill = GridBagConstraints.HORIZONTAL;
	cc.weightx = 10;
	cc.gridwidth = 0;

	c = new Label("Numeric Textfield:");
	gb.setConstraints(c, cc);
	add(c);

	c = new NumericTextField();
	gb.setConstraints(c, cc);
	add(c);

	c = new Label("Caps Lock Textfield:");
	gb.setConstraints(c, cc);
	add(c);

	c = new UpperCaseTextField(false);
	gb.setConstraints(c, cc);
	add(c);

	c = new Label("Shift Lock Textfield:");
	gb.setConstraints(c, cc);
	add(c);

	c = new UpperCaseTextField(true);
	gb.setConstraints(c, cc);
	add(c);

	setBounds(100, 100, 200, 100);
	setVisible(true);
    }

    public static void main(String args[]) {
      Frame f = new Frame("EventTest");
      EventTest bordertest = new EventTest();

      bordertest.init();
      bordertest.start();

      f.add("Center", bordertest);
      f.setSize(200, 200);
      f.setCursor(Frame.TEXT_CURSOR);
      f.setVisible(true);
    }
}

class UpperCaseTextField extends TextField {
    String ptext;
    boolean shift;

    public UpperCaseTextField(boolean shift) {
	this.shift = shift;
    }

    public boolean action(Event e, Object a) {
	System.out.println("ACTION: " + e);
	return true;
    }

    public boolean handleEvent(Event e) {
	switch (e.id) {
	  case Event.KEY_PRESS:
	  case Event.KEY_RELEASE:
	    // skip tabs
	    if (e.key != '\t') {
	       if (shift) {
	           // skip returns
	   	   if (e.key != '\n') {
		       e.modifiers |= Event.SHIFT_MASK;
		   }
	       } else if (e.key >= 'a' && e.key <= 'z') {
	   	   e.key = (e.key - 'a') + 'A';
	       }
	    }
	    return super.handleEvent(e);
	  default:
	    return super.handleEvent(e);
	}
    }
}

class NumericTextField extends TextField {
    String ptext;

    public boolean action(Event e, Object a) {
	System.out.println("ACTION: " + e);
	return true;
    }
    public boolean handleEvent(Event e) {
	switch (e.id) {
	  case Event.KEY_PRESS:
	  case Event.KEY_RELEASE:
	    switch (e.key) {
	      case '0':
	      case '1':
	      case '2':
	      case '3':
	      case '4':
	      case '5':
	      case '6':
	      case '7':
	      case '8':
	      case '9':
		return false;
	      case '.':
		return getText().indexOf('.') != -1;
	      case '\t':
	      case 127:
	      case 8:
	      case 10:
		return super.handleEvent(e);
	      case 1: // ^A
		select(0,0);
		return true;
	      case 2: // ^B
		if (e.id==Event.KEY_PRESS) {
		    int start = getSelectionStart() - 1;
		    select(start,start);
		}
		return true;
	      case 5: // ^E
		select(9999,9999);
		return true;
	      case 6: // ^F
		if (e.id==Event.KEY_PRESS) {
		    int start = getSelectionStart() + 1;
		    select(start,start);
		}
		return true;
	      case 11: // ^K
		if (e.id == Event.KEY_PRESS) {
		    ptext = getText();
		}
		setText("");
		return true;
	      case 25: // ^Y
		setText(ptext);
		return true;
	      case 16: // ^P
		setText("previous");
		return true;
	      default:

		return true;
	    }
	  default:
	    return super.handleEvent(e);
	}
    }
}

	
