/*
 * @(#)FileDialogTest.java	1.3 96/12/06
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
/*
 *	Initially written by Siebe
 *	Subsequently modified by Vijay Srinivasan
 *
 */

import java.awt.*;
import java.applet.*;
import java.io.*;

public class FileDialogTest extends TestApplet {
    FileDialogFrame fdf;

  public void init() {
    fdf = new FileDialogFrame();
    fdf.resize(400, 200);
    fdf.show();
  }

  public static void main(String argv[]) {
    FileDialogFrame fdf = new FileDialogFrame();
    fdf.resize(400, 200);
    fdf.show();
  }
}

class FileDialogFrame extends Frame{
    protected MenuBar menubar;
    protected FileDialog fileDialogLoad;
    protected FileDialog fileDialogSave;
    protected Choice setMode;
    protected TextField setDirectory;
    protected TextField setFile;
    protected TextField fileNameFilter;
    protected TextField pathFilter;

    public FileDialogFrame() {  	
        super("FileDialogTest");
	Panel p = new Panel();
	
	setMode = new Choice();
	setMode.addItem("LOAD");
	setMode.addItem("SAVE");
	
	p.setLayout(new GridLayout(0,2));	
	p.add(new Label("setDirectory"));
	p.add(setDirectory = new TextField("~/"));
	p.add(new Label("setFile"));
	p.add(setFile = new TextField("*"));
	p.add(new Label("setPathFilter"));
	p.add(pathFilter = new TextField("~/"));
	p.add(new Label("setFileNameFilter"));
	p.add(fileNameFilter = new TextField("*"));
	
	p.add(new Label("setMode"));
	p.add(setMode);
	
	fileDialogLoad = new FileDialog(this, "fileDialogLoad", FileDialog.LOAD);
	fileDialogSave = new FileDialog(this, "fileDialogSave", FileDialog.SAVE);	
	buildMenuBar();
	setMenuBar(menubar);
	add("North",p);
	move(100,200);
	pack();
	show();
    }
    protected void buildMenuBar() {
        menubar = new MenuBar();
	Menu mn = new Menu("FileDialogTest");
	mn.add(new MenuItem("showFileDialog"));
	mn.add(new MenuItem("toFront"));
	mn.add(new MenuItem("toBack"));
	mn.add(new MenuItem("dispose"));
       	menubar.add(mn);
    }

    public boolean handleEvent(Event evt) {	
	
	if (evt.id == Event.ACTION_EVENT) {
	    if("dispose".equals(evt.arg)) {
		System.out.println("dispose");
	    	dispose();
	    	return true;
	    }
	    if("toBack".equals(evt.arg)) {
	    	System.out.println("toBack");
	    	toBack();
	    	return true;
	    }
	    if("toFront".equals(evt.arg)) {
		System.out.println("toFront");
	    	toFront();
	    	return true;
	    }
	    // Using for load and save 2 different FileDiagramObjects
	    if("showFileDialog".equals(evt.arg)) {
	    	
		// get the right fileDialog object "SAVE" or "LOAD"
		FileDialog fileDialog = ((setMode.getSelectedItem() == "SAVE")?fileDialogSave:fileDialogLoad);
		
		
		// set the fileNameFilter in this FileDialog object
		FileName fileName = new FileName(pathFilter.getText(), fileNameFilter.getText());
		fileDialog.setFilenameFilter(fileName);
		
		// set the directory in the FileDialog object
		fileDialog.setDirectory(setDirectory.getText());
		
		// set the file in the FileDialog object
		fileDialog.setFile(setFile.getText());
                
		// show this fileDialog to the screen
		fileDialog.show();
	    	
		// print the variables to the screen
		System.out.println("********* showFileDialog *********");
		System.out.println("getFile = " + fileDialog.getFile());
	    	System.out.println("getMode = " + fileDialog.getMode());
		System.out.println("getDirectory = " + fileDialog.getDirectory());
	    	fileName = (FileName)fileDialog.getFilenameFilter();
		System.out.println("fileNameFilter path = " + fileName.path);
		System.out.println("fileNameFilter name = " + fileName.fileName);
		return true;
	    }
	}
	return false;
    }
public static void main(String args[]) {
    	new FileDialogTest();
	
    }
} 

class FileName implements FilenameFilter {
    
    public String path;
    public String fileName;
    FileName(String p, String n) {
    	path = p;
	fileName = n;
    }

    public boolean accept(File dir, String name) {
    	System.out.println("dir Filter = " + dir.getPath());
	System.out.println("name Filter = " + name);
	System.out.println("this path = " + path);
	System.out.println("this fileName = " + fileName);

	if(path.equals(dir.getPath()) && name.equals(fileName)) {
	    System.out.println("true");
	    return true;
	}
	System.out.println("false");
	return false;
    }
}
	
