/*
 * @(#)FontMetricsTest.java	1.1 97/02/20
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.io.*;

/**
 * Font metrics test program.  This program verifies that a minimal
 * subclass which only overrides the methods mentioned in the class
 * comments for FontMetrics will successfully avoid the infinite
 * recursion in the methods of that abstract class.  It also tests
 * a platform FontMetrics class to see if it has recursion problems.
 *
 * To run it, simply compile it and type "java FontMetricsTest".
 * You should get two "PASS" statements.
 *
 * @(#)FontMetricsTest.java	1.1  02/20/97 16:20:35
 * @author Jim Graham
 */
public class FontMetricsTest extends java.awt.FontMetrics {
    static int failures = 0;

    public static void main(String argv[]) {
	Font f = new Font("Courier", Font.PLAIN, 12);
	FontMetricsTest fmt = new FontMetricsTest(f);
	test(fmt);
	System.out.println("minimal subclass recursion test: "+
			   (failures > 0 ? "FAIL" : "PASS"));
	failures = 0;
	FontMetrics fm = new Frame().getFontMetrics(f);
	test(fm);
	System.out.println("platform implementation recursion test: "+
			   (failures > 0 ? "FAIL" : "PASS"));
	System.exit(0);
    }

    public FontMetricsTest(Font f) {
	super(f);
    }

    static char charr[] = {' '};
    static byte byarr[] = { 32 };

    public static void show(Throwable e) {
	failures++;
	new Error(e.toString()).printStackTrace();
    }

    public static void test(FontMetrics fm) {
	try {fm.getFont();} catch (Throwable e) {show(e);}
	try {fm.getLeading();} catch (Throwable e) {show(e);}
	try {fm.getAscent();} catch (Throwable e) {show(e);}
	try {fm.getDescent();} catch (Throwable e) {show(e);}
	try {fm.getHeight();} catch (Throwable e) {show(e);}
	try {fm.getMaxAscent();} catch (Throwable e) {show(e);}
	try {fm.getMaxDescent();} catch (Throwable e) {show(e);}
	try {fm.getMaxAdvance();} catch (Throwable e) {show(e);}
	try {fm.charWidth(' ');} catch (Throwable e) {show(e);}
	try {fm.charWidth(32);} catch (Throwable e) {show(e);}
	try {fm.stringWidth(" ");} catch (Throwable e) {show(e);}
	try {fm.charsWidth(charr,0,1);} catch (Throwable e) {show(e);}
	try {fm.bytesWidth(byarr,0,1);} catch (Throwable e) {show(e);}
	try {fm.getWidths();} catch (Throwable e) {show(e);}
	try {fm.toString();} catch (Throwable e) {show(e);}
    }

    public int charWidth(char ch) {
	return 0;
    }

    public int charsWidth(char charr[], int off, int len) {
	return 0;
    }
}
