/*
 * @(#)FontTest.java	1.5 96/12/06
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
/* Font test routines
 * @(#)FontTest.java	1.5  12/06/96 17:00:12
 * @author Kevin A. Smith
 */

import java.awt.*;
import java.util.Properties;
import java.applet.Applet;

public class FontTest extends Applet
{
    // class variables
    private Choice    fontNameList;
    private TextField fontSize;
    private TextArea  textArea;
    private TextField fontInfo;
    private Checkbox  fontBold;
    private Checkbox  fontItalic;
    private Choice    fontInfoChoice;
    private Choice    fontMetricsList;
    private TextField metricInfo;

    private final int DEF_FONT_SIZE = 12;

    private final String infoTypes[] = 
    {
       "getFamily",
       "getName",
       "getSize",
       "getStyle",
       "hashCode",
       "isBold",
       "isItalic",
       "isPlain",
       "toString"
    };

    private final String metricTypes[] =
    {
       "bytesWidth",
       "charWidth",
       "charsWidth",
       "getAscent",
       "getDescent",
       "getFont",
       "getHeight",
       "getLeading",
       "getMaxAdvance",
       "getMaxDecent",
       "getMaxDescent",
       "getWidths",
       "stringWidth",
       "toString"
    };

    // create screen objects
    public FontTest()
    {
       // local variables
       int i;
       String fontNames[];
       Panel fontsPanel = new Panel();
       Panel tempPanel = new Panel();

       fontsPanel.setLayout( new GridLayout(3, 1) );

       // create first panel
       tempPanel.add( new Label("Font Name:") );
       tempPanel.add( fontNameList = new Choice() );
       tempPanel.add( new Label("Size:") );
       tempPanel.add( fontSize = new TextField( 
                               Integer.toString(DEF_FONT_SIZE),
                               3) );
       tempPanel.add( new Label("Style:") );
       tempPanel.add( fontBold = new Checkbox("Bold") );
       tempPanel.add( fontItalic = new Checkbox("Italic") );
       fontsPanel.add( tempPanel );

       // create second panel
       tempPanel = new Panel();
       tempPanel.add( new Label("Font") );
       tempPanel.add( fontInfoChoice = new Choice() );
       tempPanel.add( fontInfo = new TextField("Unknown method", 40) );
       fontInfo.setEditable(false);
       fontsPanel.add( tempPanel );

       // font metrics stuff
       tempPanel = new Panel();
       tempPanel.add( new Label("Font Metrics") );
       tempPanel.add( fontMetricsList = new Choice() );
       tempPanel.add( metricInfo = new TextField("Unknown metric", 40) );
       metricInfo.setEditable(false);
       fontsPanel.add( tempPanel );

       // get list of fonts and populate choice list
       fontNames = getToolkit().getFontList();
       for (i = 0; i < fontNames.length; ++i)
          fontNameList.addItem( fontNames[i] );

       // add additional font choices
       fontNameList.addItem("Current Font");

       // set font choice types
       for (i = 0; i < infoTypes.length; ++i)
          fontInfoChoice.addItem( infoTypes[i] );

       // set Metrics info choice
       for (i = 0; i < metricTypes.length; ++i)
          fontMetricsList.addItem( metricTypes[i] );

       // place panels into applet
       setLayout( new BorderLayout() );
       add( "North", fontsPanel );
       add( "Center", textArea = new TextArea(100, 10) );
    
    }

    // initialize screen objects
    public void init()
    {
       // set the initial values
       setTextFont();
       resize(600, 400);
    }

    public boolean action(Event evt, Object obj)
    {
       // check type of event
       if ( (evt.target instanceof TextField) ||
            (evt.target instanceof Checkbox)  )
       {
          setTextFont();  
          return true;
       }
       else if (evt.target instanceof Choice)
       {
          if ( evt.target.equals(fontNameList) )
             setTextFont();
          else if ( evt.target.equals(fontMetricsList) )
             getMetrics();
          else if ( evt.target.equals(fontInfoChoice) )
             getFontInfo();
          else
             return false;

          return true;
       }
       else
          return super.action(evt, obj);

    }

    private void setTextFont()
    {
       // local variables
       Font     font;
       String   fontName;
       int      iFontSize;
       int      fontStyle;

       // Get fontName
       fontName = fontNameList.getSelectedItem();
       if ( fontName.equals("Current Font") )
          font = ( Font.getFont("Current Font", textArea.getFont() ) );
       // create a font from scratch
       else
       {
          // get font size
          try
          {
             iFontSize = Integer.parseInt( fontSize.getText() );
          }
          catch(NumberFormatException e)
          {
             iFontSize = DEF_FONT_SIZE;
          }
       
          // get Font Style
          if ( fontBold.getState() )
             fontStyle = Font.BOLD;
          else
             fontStyle = Font.PLAIN;

          if ( fontItalic.getState() )
             fontStyle = fontStyle | Font.ITALIC;

          // create the new font
           font = new Font(fontName, fontStyle, iFontSize);
       }  // end else create new font

       // set the text area font
       if (! font.equals( textArea.getFont() ) )
       {
          textArea.setFont(font);
          fontSize.setText( Integer.toString( font.getSize() ) );
       }

       // now report back the info from this font
       getFontInfo();
       getMetrics();

    }

    private void getFontInfo()
    {
       Font tempFont = textArea.getFont();
       String label = fontInfoChoice.getSelectedItem();
       
       // which string is it
       if ( label.equals("getFamily") )
          fontInfo.setText( tempFont.getFamily() );

       else if ( label.equals("getName") )
          fontInfo.setText( tempFont.getName() );

       else if ( label.equals("getSize") )
          fontInfo.setText( Integer.toString( tempFont.getSize() ) );

       else if ( label.equals("getStyle") )
       {
          if (tempFont.getStyle() == Font.PLAIN)
             fontInfo.setText("Plain");
          else
          {
             if ( (tempFont.getStyle() & Font.BOLD) != 0 &&
                  (tempFont.getStyle() & Font.ITALIC) != 0 )
             {
                fontInfo.setText( "Bold, Italic "); 
             }
             else if ( (tempFont.getStyle() & Font.ITALIC) != 0 )
                fontInfo.setText( "Italic" );
             else if ( (tempFont.getStyle() & Font.BOLD) != 0 )
                fontInfo.setText("Bold");
             else
                fontInfo.setText("Unknown Style");
          }
       }

       else if ( label.equals("hashCode") )
          fontInfo.setText( Integer.toString( tempFont.hashCode() ) );

       else if ( label.equals("isBold") )
          fontInfo.setText( new Boolean( tempFont.isBold() ).toString() );

       else if ( label.equals("isItalic") )       
          fontInfo.setText( new Boolean( tempFont.isItalic() ).toString() );

       else if ( label.equals("isPlain") )
          fontInfo.setText( new Boolean( tempFont.isPlain() ).toString() );

       else if ( label.equals("toString") )
          fontInfo.setText( tempFont.toString() );

       else
          fontInfo.setText("Unknown method call");
    }

    private void getMetrics()
    {
       // local variables
       FontMetrics fm = getToolkit().getFontMetrics( textArea.getFont() );
       String label = fontMetricsList.getSelectedItem();
       byte bytes[] = { 'a', 'b', 'c', 'd', 'e' };
       char chars[] = { 'A', 'B', 'C', 'D', 'E' };
       int widths[];
       int i;
       StringBuffer tempString = new StringBuffer("");

       if ( label.equals("bytesWidth") )
          metricInfo.setText( Integer.toString( fm.bytesWidth(bytes,0, bytes.length) ) );

       else if ( label.equals("charWidth") )
          metricInfo.setText( Integer.toString( fm.charWidth('W') ) );

       else if ( label.equals("charsWidth") )
          metricInfo.setText( Integer.toString( fm.charsWidth(chars, 0, chars.length) ) );
    
       else if ( label.equals("getAscent") )
          metricInfo.setText( Integer.toString( fm.getAscent() ) );

       else if ( label.equals("getDescent") )
          metricInfo.setText( Integer.toString( fm.getDescent() ) );

       else if ( label.equals("getFont") )
          metricInfo.setText( fm.getFont().toString() );

       else if ( label.equals("getHeight") )
          metricInfo.setText( Integer.toString( fm.getHeight() ) );

       else if ( label.equals("getLeading") )
          metricInfo.setText( Integer.toString( fm.getLeading() ) ) ;

       else if ( label.equals("getMaxAdvance") )
          metricInfo.setText( Integer.toString( fm.getMaxAdvance() ) );

       else if ( label.equals("getMaxDecent") ) 
          metricInfo.setText( Integer.toString( fm.getMaxDecent() ) );

       else if ( label.equals("getMaxDescent") )
             metricInfo.setText( Integer.toString( fm.getMaxDescent() ) );

       else if ( label.equals("getWidths") )
       {
          widths = fm.getWidths();
          for (i = 0; i < widths.length; ++i)
             tempString.append( Integer.toString(widths[i]) + ", " );

          metricInfo.setText( tempString.toString() );
       }

       else if ( label.equals("stringWidth") )
          metricInfo.setText( Integer.toString( fm.stringWidth( textArea.getText() ) ) );

       else if ( label.equals("toString") )
          metricInfo.setText( fm.toString() );

       else
          metricInfo.setText("Unknown Font Metric");

    }

    public static void main(String args[])
    {
       AppletFrame.startApplet("FontTest", "Font Test", args);
    }
}
