/*
 * @(#)FrameEvents.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

class FrameEvents extends Frame {
  public FrameEvents() {
    super();
  }

  public FrameEvents(String s) {
    super(s);
  }

   public boolean handleEvent(Event evt) {
    switch (evt.id) {
      case Event.ACTION_EVENT:
        System.out.println("Action_Event: " + evt);
      case Event.ALT_MASK:
        System.out.println("Alt modf const: " + evt);
	break;
      case Event.CTRL_MASK:
        System.out.println("Control modf const: " + evt);
	break;
      case Event.LOST_FOCUS:
        System.out.println("Lost_Focus: " + evt);
	break;
      case Event.GOT_FOCUS:
        System.out.println("Got_Focus: " + evt);      
	break;
      case Event.KEY_PRESS:
        System.out.println("Key press: " + evt);
	break;
      case Event.KEY_RELEASE:
        System.out.println("Key release: " + evt);
	break;
      case Event.KEY_ACTION_RELEASE:
      case Event.KEY_ACTION: {
	if (evt.id == Event.KEY_ACTION) {
	    System.out.print("Action key press - ");
	} else {
	    System.out.print("Action key release - ");
	}
	switch(evt.key) {
     	  case Event.DOWN:
            System.out.println("Down arrow key: " + evt);
	    break;
      	  case Event.UP:
       	    System.out.println("Up arrow key: " + evt);
	    break;
          case Event.HOME:
            System.out.println("Home key: " + evt);
	    break;	
     	  case Event.END:
            System.out.println("End key: " + evt);
	    break;
      	  case Event.LEFT:
            System.out.println("Left arrow key: " + evt);
	    break;
      	  case Event.RIGHT:
            System.out.println("Right_arrow key: " + evt);
	    break;
          case Event.PGDN:
            System.out.println("Page_down key: " + evt);
	    break;
      	  case Event.PGUP:
       	    System.out.println("Page_up key: " + evt);
	    break;
          case Event.F1:
            System.out.println("F1 Key: " + evt);
	    break;
          case Event.F2:
            System.out.println("F2 Key: " + evt);
  	    break;
          case Event.F3:
            System.out.println("F3 Key: " + evt);
	    break;
     	  case Event.F4:
            System.out.println("F4 Key: " + evt);
	    break;
      	  case Event.F5:
            System.out.println("F5 Key: " + evt);
	    break;
      	  case Event.F6:
            System.out.println("F6 Key: " + evt);
	    break;
      	  case Event.F7:
            System.out.println("F7 Key: " + evt);
	    break;
      	  case Event.F8:
            System.out.println("F8 Key: " + evt);
	    break;
     	  case Event.F9:
            System.out.println("F9 Key: " + evt);
	    break;
      	  case Event.F10:
            System.out.println("F10 Key: " + evt);
	    break;
      	  case Event.F11:
            System.out.println("F11 Key: " + evt);
	    break;
      	  case Event.F12:
            System.out.println("F12 Key: " + evt);
	    break;
	  default:
	    System.out.println("unknown key: " + evt);
        }
        break;
      }
      case Event.LIST_DESELECT:
        System.out.println("List Deselect: " + evt);
	break;
      case Event.LIST_SELECT:
        System.out.println("List Select: " + evt);
	break;
      case Event.LOAD_FILE:
        System.out.println("File Loading evt: " + evt);
	break;
      case Event.SAVE_FILE:
        System.out.println("Save File evt: " + evt);
	break;	
      case Event.META_MASK:
        System.out.println("Meta modf const: " + evt);
	break;
      case Event.MOUSE_DOWN:
        System.out.println("Mouse_down: " + evt);
	break;
      case Event.MOUSE_UP:
        System.out.println("Mouse_up: " + evt);
	break;
      case Event.MOUSE_DRAG:
        System.out.println("Mouse_drag: " + evt);
	break;
      case Event.MOUSE_ENTER:
        System.out.println("Mouse_enter: " + evt);
	break;
      case Event.MOUSE_EXIT:
        System.out.println("Mouse_exit: " + evt);
	break;
      case Event.MOUSE_MOVE:
        System.out.println("Mouse_move: " + evt);
	break;
      case Event.SCROLL_ABSOLUTE:
        System.out.println("Scroll_absolute: " + evt);
	break;
      case Event.SCROLL_LINE_DOWN:
        System.out.println("Scroll_line_down: " + evt);
	break;
      case Event.SCROLL_LINE_UP:
        System.out.println("Scroll_line_up: " + evt); 
	break;
      case Event.SCROLL_PAGE_DOWN:
        System.out.println("Scroll_page_down: " + evt);
	break;
      case Event.SCROLL_PAGE_UP:
        System.out.println("Scroll_page_up: " + evt);
	break;
      case Event.SHIFT_MASK:
        System.out.println("Shift modf const: " + evt);
	break;
      case Event.WINDOW_DEICONIFY:
        System.out.println("Window_deiconify evt: " + evt);
	break;
      case Event.WINDOW_DESTROY:
        System.out.println("Window_destroy evt: " + evt);
	break;
      case Event.WINDOW_EXPOSE:
        System.out.println("Window_expose evt: " + evt);
	break;
      case Event.WINDOW_ICONIFY:
        System.out.println("Window_iconify evt: " + evt);
	break;
      case Event.WINDOW_MOVED:
        System.out.println("Window_moved evt: " + evt);
	break;
      default:
        System.out.println("Cannot understand evt: " + evt);
	System.out.println("passing it to super");
    }
   return super.handleEvent(evt);
  }
}
