/*
 * @(#)FrameTest.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

public class FrameTest extends TestApplet {
  TestFrame tf;
  Image cursorimg, iconimg, newiconimg;

  public void init() {
    cursorimg = getImage(getDocumentBase(), "images/cursor.gif");
    iconimg = getImage(getDocumentBase(), "images/icon.gif");
    newiconimg = getImage(getDocumentBase(), "images/newicon.gif");

    tf = new TestFrame("FrameTest", cursorimg, iconimg, newiconimg);
    tf.resize(300, 300);
    tf.show();
  }
}


class TestFrame extends Frame {
  Image cursorimg, iconimg, newiconimg;
  MenuBar mb1, mb2;
  Menu filemenu, opsmenu, editmenu, formatmenu;
  
  public TestFrame(String s, Image cimg, Image iimg, Image niimg) {
    super();
    cursorimg = cimg;
    iconimg = iimg;
    newiconimg = niimg;
    setTitle(s);

    filemenu = new Menu("File");
    opsmenu = new Menu("Operations");

    filemenu.add(new MenuItem("Load"));
    filemenu.add(new MenuItem("Save"));
    filemenu.add(new MenuItem("Quit"));
    opsmenu.add(new MenuItem("Bringover"));
    opsmenu.add(new MenuItem("Putback"));
    opsmenu.add(new MenuItem("Change Title"));
    opsmenu.add(new MenuItem("Change MenuBar"));
    opsmenu.add(new MenuItem("Change IconImage"));

    editmenu = new Menu("Edit");
    formatmenu = new Menu("Format");
    editmenu.add(new MenuItem("Cut"));
    editmenu.add(new MenuItem("Paste"));
    editmenu.add(new MenuItem("Copy"));
    editmenu.add(new MenuItem("Quit"));
    editmenu.add(new MenuItem("Change MenuBar"));
    formatmenu.add(new MenuItem("Font"));
    formatmenu.add(new MenuItem("Style"));
    mb2 = new MenuBar();
    mb2.add(editmenu);
    mb2.add(formatmenu);
    
    setMenuBar(new MenuBar());
    getMenuBar().add(filemenu);
    getMenuBar().add(opsmenu);

    setResizable(false);
//    setCursor(cursorimg);
    setIconImage(iconimg);
  }

  public boolean action(Event evt, Object arg) {
    if (evt.target instanceof MenuComponent)
      if ("Change MenuBar".equals(arg)) {
	mb1 = getMenuBar();
	remove(mb1);
	setMenuBar(mb2);
	mb2 = mb1;
	validate();
      } else if ("Quit".equals(arg)) {
	dispose();
      } else if ("Change Title".equals(arg)){
	System.out.println("Old Title: " + getTitle());
	System.out.println("New Title: TitleChangeTest");
	setTitle("TitleChangeTest");
	try {
	  Thread.sleep(4000);
	} catch(InterruptedException e){
	    System.out.println("InterruptedException caught...exiting");
	    dispose();
	    System.exit(0);
	}
	System.out.println("Resetting title to old\n");
	setTitle("FrameTest");
      } else if("Change IconImage".equals(arg)) {
	setIconImage(newiconimg);
      } else {
	// These calls only serve the purpose of testing the methods.
	getIconImage();
	isResizable();
	return false;
      }
    return true;
  }
}

