/*
 * @(#)GraphicsTest.java	1.7 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;
import java.applet.*;

public class GraphicsTest extends TestApplet {
    GraphicsCards	cards;
    public void init() {
	setLayout(new BorderLayout());
	add("Center", cards = new GraphicsCards());
	Panel p = new Panel();
	p.add(new Button("next"));
	p.add(new Button("previous"));
	p.add(new Label("go to:", Label.RIGHT));

	Choice c;

	p.add(c = new Choice());
	c.addItem("Arc");
	c.addItem("Oval");
	c.addItem("Polyline");
	c.addItem("Polygon");
	c.addItem("Rect");
	c.addItem("RoundRect");
	add("North", p);
    }
    public boolean action(Event evt, Object arg) {
	if (evt.target instanceof Choice) {
	    ((CardLayout)cards.getLayout()).show(cards,(String)arg);
	} else {
	    if ("next".equals(arg)) {
		((CardLayout)cards.getLayout()).next(cards);
	    } else if ("previous".equals(arg)) {
		((CardLayout)cards.getLayout()).previous(cards);
	    }
	}

	return true;
    }

    public static void main(String args[]) {
	GraphicsFrame f = new GraphicsFrame();
	GraphicsTest graphicsTest = new GraphicsTest();

	graphicsTest.init();
	f.add("Center", graphicsTest);
	f.resize(300, 300);
	f.show();
    }
}

class GraphicsFrame extends Frame {
    public GraphicsFrame() {
	super("Graphics Test");
    }
    public boolean handleEvent(Event e) {
	if (e.id == Event.WINDOW_DESTROY) {
	    System.exit(0);
	}
	return false;
    }
}
    
class GraphicsCards extends Panel {
    public GraphicsCards() {
	setLayout(new CardLayout());
	add("Arc", new ArcCard());
	add("Oval", new ShapeTest(new OvalShape()));
	add("Polyline", new ShapeTest(new PolylineShape()));
	add("Polygon", new ShapeTest(new PolygonShape()));
	add("Rect", new ShapeTest(new RectShape()));
	add("RoundRect", new ShapeTest(new RoundRectShape()));
    }
}


class ArcCard extends Panel {
    public ArcCard() {
	setLayout(new GridLayout(0, 2));
	add(new ArcPanel(true));
	add(new ArcPanel(false));
	add(new ArcDegreePanel(true));
	add(new ArcDegreePanel(false));
    }
}

class ArcDegreePanel extends Panel {
    boolean filled;
    public ArcDegreePanel(boolean filled) {
	this.filled = filled;
    }
    void arcSteps(Graphics g,
		  int step, int x, int y, int w, int h,
		  Color c1,
		  Color c2) {
	int a1 = 0;
	int a2 = step;
	int progress = 0;
	g.setColor(c1);
	for (; (a1+a2) <= 360; a1 = a1+a2, a2 += 1 ) {
	    if (g.getColor() == c1) {
		g.setColor(c2);
	    } else {
		g.setColor(c1);
	    }
	    if (filled) {
		g.fillArc(x, y, w, h, a1, a2);
	    } else {
		g.drawArc(x, y, w, h, a1, a2);
	    }
	    progress = a1+a2;
	}
	if (progress != 360) {
	    if (filled) {
		g.fillArc(x, y, w, h, a1, 360 - progress);
	    } else {
		g.drawArc(x, y, w, h, a1, 360 - progress);
	    }
	}
    }
    public void paint(Graphics g) {
	Rectangle r = bounds();

	arcSteps(g, 3, 0, 0, r.width, r.height,
		 Color.orange, Color.blue);
	arcSteps(g, 2, r.width / 4, r.height / 4, r.width / 2, r.height / 2,
		 Color.yellow, Color.green);
	arcSteps(g, 1,
		 (r.width  * 3) / 8,
		 (r.height * 3) / 8,
		 r.width / 4, r.height / 4,
		 Color.magenta, Color.white);
    }
}

class ArcPanel extends Panel {
    boolean filled;
    public ArcPanel(boolean filled) {
	this.filled = filled;
    }
    public void paint(Graphics g) {
	Rectangle r = bounds();
	g.setColor(Color.yellow);
	if (filled) {
	    g.fillArc(0, 0, r.width, r.height, 0, 45);
	} else {
	    g.drawArc(0, 0, r.width, r.height, 0, 45);
	}
	g.setColor(Color.green);
	if (filled) {
	    g.fillArc(0, 0, r.width, r.height, 90, -45);
	} else {
	    g.drawArc(0, 0, r.width, r.height, 90, -45);
	}
	g.setColor(Color.orange);
	if (filled) {
	    g.fillArc(0, 0, r.width, r.height, 135, -45);
	} else {
	    g.drawArc(0, 0, r.width, r.height, 135, -45);
	}
	g.setColor(Color.magenta);
	if (filled) {
	    g.fillArc(0, 0, r.width, r.height, -225, 45);
	} else {
	    g.drawArc(0, 0, r.width, r.height, -225, 45);
	}

	g.setColor(Color.yellow);
	if (filled) {
	    g.fillArc(0, 0, r.width, r.height, 225, -45);
	} else {
	    g.drawArc(0, 0, r.width, r.height, 225, -45);
	}
	g.setColor(Color.green);
	if (filled) {
	    g.fillArc(0, 0, r.width, r.height, -135, 45);
	} else {
	    g.drawArc(0, 0, r.width, r.height, -135, 45);
	}
	g.setColor(Color.orange);
	if (filled) {
	    g.fillArc(0, 0, r.width, r.height, -45, -45);
	} else {
	    g.drawArc(0, 0, r.width, r.height, -45, -45);
	}
	g.setColor(Color.magenta);
	if (filled) {
	    g.fillArc(0, 0, r.width, r.height, 315, 45);
	} else {
	    g.drawArc(0, 0, r.width, r.height, 315, 45);
	}
    }
}

abstract class Shape {
    abstract void draw(Graphics g, int x, int y, int w, int h);
    abstract void fill(Graphics g, int x, int y, int w, int h);
}

class RectShape extends Shape {
    void draw(Graphics g, int x, int y, int w, int h) {
	g.drawRect(x, y, w, h);
    }
    void fill(Graphics g, int x, int y, int w, int h) {
	g.fillRect(x, y, w, h);
    }
}

class OvalShape extends Shape {
    void draw(Graphics g, int x, int y, int w, int h) {
	g.drawOval(x, y, w, h);
    }
    void fill(Graphics g, int x, int y, int w, int h) {
	g.fillOval(x, y, w, h);
    }
}

class RoundRectShape extends Shape {
    void draw(Graphics g, int x, int y, int w, int h) {
	g.drawRoundRect(x, y, w, h, 10, 10);
    }
    void fill(Graphics g, int x, int y, int w, int h) {
	g.fillRoundRect(x, y, w, h, 10, 10);
    }
}

abstract class PolyShape extends Shape {
    Polygon p;

    public PolyShape() {
	setPolygon();
    }

    void setPolygon() {
	p = new Polygon();
	p.addPoint(0, 0);
	p.addPoint(10, 0);
	p.addPoint(5, 15);
	p.addPoint(10, 20);
	p.addPoint(5, 20);
	p.addPoint(0, 10);
    }

    Polygon scalePolygon(Polygon p, float sw, float sh) {
	Polygon ps = new Polygon();
	int i;

	for (i=0; i < p.npoints; i++) {
	    ps.addPoint((int)(((float)p.xpoints[i]) * sw),
			(int)(((float)p.ypoints[i]) * sh));
	}

	return ps;
    }

    abstract void drawPoly(Graphics g, Polygon p);
    abstract void fillPoly(Graphics g, Polygon p);

    void draw(Graphics g, int x, int y, int w, int h) {
	g.translate(x, y);
	Polygon p2 = scalePolygon(p, (float) w / 10f, (float) h / 20f);
	drawPoly(g, p2);
	g.translate(-x, -y);
    }

    void fill(Graphics g, int x, int y, int w, int h) {
	g.translate(x, y);
	Polygon p2 = scalePolygon(p, (float) w / 10f, (float) h / 20f);
	fillPoly(g, p2);
	g.translate(-x, -y);
    }
}

class PolylineShape extends PolyShape {
    void drawPoly(Graphics g, Polygon p) {
	g.drawPolyline(p.xpoints, p.ypoints, p.npoints);
    }
    void fillPoly(Graphics g, Polygon p) {
	g.drawPolyline(p.xpoints, p.ypoints, p.npoints);
    }
}

class PolygonShape extends PolyShape {
    boolean which;

    void drawPoly(Graphics g, Polygon p) {
	if (which) {
	    g.drawPolygon(p);
	} else {
	    g.drawPolygon(p.xpoints, p.ypoints, p.npoints);
	}
	which = !which;
    }
    void fillPoly(Graphics g, Polygon p) {
	g.fillPolygon(p);
    }
}

class ShapeTest extends Panel {
    Shape	shape;
    int		step;

    public ShapeTest(Shape shape, int step) {
	this.shape = shape;
	this.step = step;
    }

    public ShapeTest(Shape shape) {
	this(shape, 10);
    }

    public void paint(Graphics g) {
	Rectangle bounds = bounds();

	int cx, cy, cw, ch;

	Color color;
	for (color=Color.red, cx=bounds.x, cy=bounds.y,
	     cw=bounds.width / 2, ch=bounds.height; 
	     cw > 0 && ch > 0;
	     cx+=step, cy += step, cw -= (step * 2), ch -= (step * 2),
	     color=ColorUtils.darker(color, 0.9)) {
	    g.setColor(color);
	    shape.draw(g, cx, cy, cw, ch);
	}
	for (cx=bounds.x + bounds.width / 2, cy=bounds.y,
	     cw=bounds.width / 2, ch=bounds.height; 
	     cw > 0 && ch > 0;
	     cx+=step, cy += step, cw -= (step * 2),ch -= (step * 2)) {
	    if (g.getColor() == Color.red) {
		g.setColor(Color.blue);
	    } else {
		g.setColor(Color.red);
	    }
	    shape.fill(g, cx, cy, cw, ch);
	}
    }
}

class ColorUtils {
    static Color brighter(Color c, double factor) {
	return new Color(Math.min((int)(c.getRed()  *(1/factor)), 255), 
			 Math.min((int)(c.getGreen()*(1/factor)), 255),
			 Math.min((int)(c.getBlue() *(1/factor)), 255));
    }
    static Color darker(Color c, double factor) {
	return new Color(Math.max((int)(c.getRed()  *factor), 0), 
			 Math.max((int)(c.getGreen()*factor), 0),
			 Math.max((int)(c.getBlue() *factor), 0));
    }
}
