/*
 * @(#)GraphicsTest2.java	1.4 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

/*
 *
 * Written by reast@esri.com
 *
 *
 */

 import java.awt.*;  
 import java.applet.*;
 
 public class GraphicsTest2 extends Applet {
 
   /** main components of the applet */
   Panel m;
   Panel g;
 
   /** minor components within panel m */
   Panel sub1;
   Panel sub2;
 
   /** a button to show the problem */
   Button b;
 
   /** button label */
   String FlipButton = "FLIP";
 
   public void start() {
 	mkButton();
 	mkButtonPanel();
 	mkMainPanel();
 	mkSubPanel1();
 	mkSubPanel2();
 	layoutMainPanel();
 
 	resizeSubPanels();
 	layoutApplet();
 
 	// end of Problem 1
 	//-----------------------------------------------------------------------------------
   }
 
   void mkButton() {
 	b = new Button(FlipButton);
 
 	//-----------------------------------------------------------------------------------
 	// PROBLEM 2:
 	//	the following setBackground and setForeground calls do not work on NT
 	//	I do not have a workaround.....
 
 	b.setBackground (Color.black);
 	b.setForeground (Color.white);
 
 	// end of Problem 2
 	//-----------------------------------------------------------------------------------
 
 	b.resize (50,30);
 	b.move (0,0);
 	b.show();
   }
 
   void mkButtonPanel() {
 	g = new Panel();
 	g.setLayout (new AbsoluteLayout ());
 	g.add (b);
 	g.setBackground (Color.cyan);
 	//g.layout();
 	//g.show();
   }
 
   void mkMainPanel() {
 	m = new Panel();
 	m.setLayout (new AbsoluteLayout ());
 
 	//-----------------------------------------------------------------------------------
 	// PROBLEM 3:
 	//	the color "pink" does not work on the NT platform.  Using "green" works fine
 
 	m.setBackground (Color.pink);
 	//m.setBackground (Color.green);
 
 	// end of Problem 3
 	//-----------------------------------------------------------------------------------
   }
 
   void mkSubPanel1() {
 	sub1 = new Panel();
 	sub1.move (0,0);
 	sub1.setBackground (Color.blue);
   }
 
   void mkSubPanel2() {
 	sub2 = new Panel();
 	sub2.move (0,0);
 	sub2.setBackground (Color.red);
 	sub2.hide();
   }
 
   void resizeSubPanels() {
 	sub1.resize (300, 200);
 	sub2.resize (100, 100);
   }
 
   void layoutMainPanel() {
 
 	//-----------------------------------------------------------
 	// Problem 4:
 	//	if line M1 occurs before line M2, then only the Unix version works Ok
 	//	if the lines are reversed, then only the NT version works Ok
 
 	m.add (sub2);				//  <<====  line M2
 	m.add (sub1);				//  <<====  line M1
 
 	// end of Problem 4
 	//-----------------------------------------------------------------------------------
   }
 
   void layoutApplet() {
 	setLayout(new BorderLayout());
 	add("Center", m);
 	add("North", g);
   }
 
   boolean showSubPanel2 = false;
 
   public boolean handleEvent (Event e) {
 	switch (e.id) {
 	  case e.ACTION_EVENT:
 		if (e.target instanceof Button) {
 			Button b = (Button) e.target;
 			if (b.getLabel().equals(FlipButton)) {
 				showSubPanel2 = !showSubPanel2;
 				if (showSubPanel2)
 					sub2.show();
 				else
 					sub2.hide();
 				return (true);
 			}
 			else
 				System.out.println ("Unknown button: "+b.getLabel());
 		}
 		else
 			System.out.println ("Action from object of class: "+e.target.getClass().toString());
 	}
 	return (false);
   }
 }
 
 class AbsoluteLayout implements LayoutManager {
  
 	public AbsoluteLayout(){
 	}
  
 	public void addLayoutComponent(String name, Component comp) {
 	}
  
 	public void removeLayoutComponent(Component comp) {
 	}
  
 	public Dimension preferredLayoutSize(Container parent) {
 		Insets insets = parent.insets();
 		int ncomponents = parent.countComponents();
 		int w = 0;
 		int h = 0;
  
 		for (int i = 0; i < ncomponents; i++) {
 			Component comp = parent.getComponent(i);
 			Dimension d = comp.preferredSize();
 			Point p = comp.location();
 			if ((p.x + d.width) > w)
 				w = p.x + d.width;
 			if ((p.y + d.height) > h)
 				h = p.y + d.height;
 		}
 		return new Dimension(insets.left + insets.right + w,
                               insets.top + insets.bottom + h);
 	}
  
      public Dimension minimumLayoutSize(Container parent) {
          Insets insets = parent.insets();
          int ncomponents = parent.countComponents();
          int w = 0;
          int h = 0;
 
          for (int i = 0; i < ncomponents; i++) {
              Component comp = parent.getComponent(i);
              Dimension d = comp.minimumSize();
              Point p = comp.location();
              if ((p.x + d.width) > w)
                  w = p.x + d.width;
              if ((p.y + d.height) > h)
                  h = p.y + d.height;
          }
 
          return new Dimension(insets.left + insets.right + w,
                               insets.top + insets.bottom + h);
      }
  
      public void layoutContainer(Container parent) {
          int     nmembers = parent.countComponents();
 
 	//Logger.Message ("Layout container: "+parent.toString());
  
          for (int i = 0; i < nmembers; i++) {
          	Component m = parent.getComponent(i);
          	//Dimension d = m.preferredSize();
          	//Dimension d = m.minimumSize();
          	//m.resize(d);
 		if (m.isVisible() && m.isShowing()) m.repaint();
          }
      }
}
