/*
 * @(#)GridEx10.java	1.3 96/12/06
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;
import java.applet.*;

public class GridEx10 extends Applet {

  protected void clear_constraints(GridBagConstraints c) {
      c.gridx = -1;		// x,y set automatically
      c.gridy = -1; 
      c.gridwidth = 1;
      c.gridheight = 1;
      c.weightx = 0;
      c.weighty = 0;
      c.fill = GridBagConstraints.NONE;
      c.anchor= GridBagConstraints.CENTER;
  }

  protected Component create_button_panel() {
      Panel		buttonPanel = new Panel();
      GridBagLayout	gridbag = new GridBagLayout();
      GridBagConstraints c = new GridBagConstraints();
      
      buttonPanel.setLayout(gridbag);

      Component	component = null;
      
      int	weight = 1;
      clear_constraints(c);
      c.weightx = weight;
      component = new Button("OK");
      gridbag.setConstraints(component, c);
      buttonPanel.add(component);
      
      clear_constraints(c);
      c.weightx = weight;
      component = new Button("Update");
      gridbag.setConstraints(component, c);
      buttonPanel.add(component);
      
      clear_constraints(c);
      c.weightx = weight;
      component = new Button("Cancel");
      gridbag.setConstraints(component, c);
      buttonPanel.add(component);
      
      clear_constraints(c);
      c.weightx = weight;
      component = new Button("Help");
      gridbag.setConstraints(component, c);
      buttonPanel.add(component);
      
      return buttonPanel;
  }
  
  protected void build_main_panel(Panel panel) {
      GridBagLayout 		gridbag = new GridBagLayout();
      GridBagConstraints 	c = new GridBagConstraints();
      Component			component = null;
      int			gridx = 0;
      int			gridy = 0;
      
      panel.setLayout(gridbag);
      
      // dir label
      clear_constraints(c);
      c.gridx = gridx;
      c.gridx = gridy++;
      c.anchor= GridBagConstraints.SOUTHWEST;
      component = new Label("Folders:");
      gridbag.setConstraints(component, c);
      panel.add(component);
      
      // dir list
      clear_constraints(c);
      c.gridx = gridx;
      c.gridy = gridy++;
      c.weightx = 1.0;
      c.weighty = 1.0;
      c.fill = GridBagConstraints.BOTH;
      component = new List();
      gridbag.setConstraints(component, c);
      panel.add(component);
      
      // Filter label
      clear_constraints(c);
      c.gridx = gridx;
      c.gridy = gridy++;
      c.anchor= GridBagConstraints.SOUTHWEST;
      component = new Label("Filter:");
      gridbag.setConstraints(component, c);
      panel.add(component);
      
      // Filter field
      clear_constraints(c);
      c.gridx = gridx;
      c.gridy = gridy++;
      c.fill = GridBagConstraints.HORIZONTAL;
      c.anchor = GridBagConstraints.NORTHWEST;
      component = new TextField();
      gridbag.setConstraints(component, c);
      panel.add(component);
      
      ++gridx;
      gridy = 0;
      
      // Files label
      clear_constraints(c);
      c.gridx = gridx;
      c.gridy = gridy++;
      c.anchor= GridBagConstraints.SOUTHWEST;
      component = new Label("Files:");
      gridbag.setConstraints(component, c);
      panel.add(component);
      
      // Files list
      clear_constraints(c);
      c.gridx = gridx;
      c.gridy = gridy;
      c.gridheight = 3;
      gridy += c.gridheight;
      c.weightx = 1.0;
      c.weighty = 1.0;
      c.fill = GridBagConstraints.BOTH;
      component = new List();
      gridbag.setConstraints(component, c);
      panel.add(component);
      
      gridx = 0;
      
      // File/Folder label
      clear_constraints(c);
      c.gridx = gridx;
      c.gridy = gridy++;
      c.anchor= GridBagConstraints.SOUTHWEST;
      component = new Label("File/Folder Name:");
      gridbag.setConstraints(component, c);
      panel.add(component);
      
      // File/Folder field
      clear_constraints(c);
      c.gridx = gridx;
      c.gridy = gridy++;
      c.gridwidth = 0;
      c.anchor = GridBagConstraints.NORTHWEST;
      c.fill = GridBagConstraints.HORIZONTAL;
      component = new TextField();
      gridbag.setConstraints(component, c);
      panel.add(component);
      
      clear_constraints(c);
      c.gridx = gridx;
      c.gridy = gridy;
      c.gridwidth = 0;
      c.fill = GridBagConstraints.HORIZONTAL;
      c.anchor = GridBagConstraints.CENTER;
      c.weightx = 1.0;
      component = create_button_panel();
      gridbag.setConstraints(component, c);
      panel.add(component);
      
  }
  
  
  public void init() {
      Panel panel;
      setFont(new Font("Helvetica", Font.BOLD, 14));
      build_main_panel(this);
  }
  
} // class
