/*
 * @(#)ImageFlushTest.java	1.4 96/12/06
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.applet.Applet;
import java.awt.Image;
import java.awt.Graphics;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Color;
import java.awt.Panel;
import java.awt.MediaTracker;

public class ImageFlushTest extends Applet {
    ImageFlushCanvas testcan;
    Checkbox goodcb;

    public void init() {
	setLayout(new BorderLayout());
	Panel p = new Panel();
	p.setLayout(new GridLayout(0, 1));
	p.add(new Button("Flush"));
	p.add(new Button("Redraw"));
	CheckboxGroup cbg = new CheckboxGroup();
	p.add(goodcb = new Checkbox("Good Image", cbg, true));
	p.add(new Checkbox("Bad Image", cbg, false));
	add("East", p);
	Image goodimg = getImage(getCodeBase(), "ImageFlushTest.gif");
	Image badimg = getImage(getCodeBase(), "bad.gif");
	testcan = new ImageFlushCanvas(goodimg, badimg);
	testcan.setImage(true);
	add("Center", testcan);
	Dimension psize = preferredSize();
	Dimension size = size();
	if (psize.width > size.width || psize.height > size.height) {
	    resize(Math.max(psize.width, size.width),
		   Math.max(psize.height, size.height));
	}
    }

    public void start() {
	testcan.start();
    }

    public boolean action(Event evt, Object arg) {
	if ("Flush".equals(arg)) {
	    testcan.flush();
	    return true;
	} else if ("Redraw".equals(arg)) {
	    testcan.redraw();
	    return true;
	} else if (evt.target instanceof Checkbox
		   && arg.equals(Boolean.TRUE)) {
	    testcan.setImage(evt.target == goodcb);
	    return true;
	}
	return false;
    }
}

class ImageFlushCanvas extends Canvas implements Runnable {
    Image goodimage;
    Image badimage;
    Image image;
    int imageID;
    MediaTracker tracker;

    public ImageFlushCanvas(Image goodimg, Image badimg) {
	goodimage = goodimg;
	badimage = badimg;
	tracker = new MediaTracker(this);
	tracker.addImage(goodimg, 0);
	tracker.addImage(badimg, 1);
    }

    public void flush() {
	image.flush();
	repaint();
    }

    public void redraw() {
	image.flush();
	start();
    }

    public void setImage(boolean good) {
	if (good) {
	    image = goodimage;
	    imageID = 0;
	} else {
	    image = badimage;
	    imageID = 1;
	}
	start();
    }

    public void start() {
	new Thread(this).start();
    }

    public void run() {
	tracker.checkID(imageID, true);
	repaint();
	try {
	    tracker.waitForID(imageID);
	} catch (InterruptedException e) {
	}
	repaint();
    }

    public void update(Graphics g) {
	paint(g);
    }

    public Dimension preferredSize() {
	return minimumSize();
    }

    public Dimension minimumSize() {
	return new Dimension(100, 120);
    }

    public void paint(Graphics g) {
	int imgstatus = tracker.statusID(imageID, false);
	Dimension d = size();
	int width = d.width;
	int height = d.height;
	if ((imgstatus & MediaTracker.ERRORED) != 0) {
	    g.setColor(Color.red);
	    g.fillRect(0, 0, width, height);
	    g.setColor(Color.black);
	    g.drawString("Error", 20, 50);
	} else if ((imgstatus & MediaTracker.ABORTED) != 0) {
	    g.setColor(Color.yellow);
	    g.fillRect(0, 0, width, height);
	    g.setColor(Color.black);
	    g.drawString("Flushed", 20, 50);
	} else {
	    g.setColor(getBackground());
	    g.fillRect(0, 0, width, height);
	    if ((imgstatus & MediaTracker.LOADING) != 0) {
		g.setColor(Color.green);
		g.drawString("Loading", 40, 20);
	    } else if ((imgstatus & MediaTracker.COMPLETE) != 0) {
		g.setColor(Color.black);
		g.drawString("Done", 40, 20);
	    }
	    g.drawImage(image, 0, 0, this);
	}
    }
}
