/*
 * @(#)ImageTest.java	1.4 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.io.InputStream;
import java.applet.Applet;
import java.awt.*;
import java.net.*;

/**
 * A simple Item class to play an image loop.  The "img" tag parameter
 * indicates what image loop to play.
 *
 * @author 	James Gosling
 * @version 	1.17, 31 Jan 1995
 */
public
class ImageTest extends TestApplet implements Runnable {
    /**
     * The current loop slot.
     */
    int loopslot = 0;

    /**
     * The directory or URL from which the images are loaded
     */
    String dir;

    /**
     * The thread animating the images.
     */
    Thread kicker = null;

    /**
     * The length of the pause between revs.
     */
    int pause;

    int offset;
    int off;
    int speed;
    int nimgs;

    /**
     * The images.
     */
    Image imgs[];
    int maxWidth;

    /**
     * Initialize the applet. Get attributes.
     */
    public void init() {
	String at = getParameter("img");
	dir = (at != null) ? at : "images/tumble";
	at = getParameter("pause");
	pause = (at != null) ? Integer.valueOf(at).intValue() : 3900;
	at = getParameter("offset");
	offset = (at != null) ? Integer.valueOf(at).intValue() : 0;
	at = getParameter("speed");
	speed = (at != null) ? (1000 / Integer.valueOf(at).intValue()) : 100;
	at = getParameter("nimgs");
	nimgs = (at != null) ? Integer.valueOf(at).intValue() : 16;
	at = getParameter("maxwidth");
	maxWidth = (at != null) ? Integer.valueOf(at).intValue() : 0;
    }

    /**
     * Run the image loop. This methods is called by class Thread.
     * @see java.lang.Thread
     */
    public void run() {
	Thread.currentThread().setPriority(Thread.NORM_PRIORITY-1);
	imgs = new Image[nimgs];
	for (int i = 1; i < nimgs; i++) {
	    imgs[i] = getImage(getDocumentBase(), dir + "/T" + i + ".gif");
	}

	Dimension d = size();
	if (nimgs > 1) {
	    if (offset < 0) {
		off = d.width - maxWidth;
	    }
	    while (kicker != null) {
		//System.out.println("frame = " +  loopslot);
		if (++loopslot >= nimgs) {
		    loopslot = 0;
		    off += offset;
		    if (off < 0) {
			off = d.width - maxWidth;
		    } else if (off + maxWidth > d.width) {
			off = 0;
		    }
		}
		repaint();
		try {
		    Thread.sleep(speed + ((loopslot == nimgs - 1) ? pause : 0));
		} catch (InterruptedException e) {
		    break;
		}
	    }
	}
    }

    public boolean imageUpdate(Image img, int flags,
			       int x, int y, int w, int h) {
	if ((flags & (SOMEBITS|FRAMEBITS|ALLBITS)) != 0) {
	    if ((imgs != null) && (loopslot < nimgs) && (imgs[loopslot] == img)) {
		repaint(100);
	    }
	}
	return (flags & (ALLBITS|ABORT)) == 0;
    }

    /**
     * Paint the current frame.
     */
    public void paint(Graphics g) {
	//System.out.println("paint");
	if ((imgs != null) && (loopslot < nimgs) && (imgs[loopslot] != null)) {
	    g.drawImage(imgs[loopslot], off, 0, this);
	}
    }

    /**
     * Start the applet by forking an animation thread.
     */
    public void start() {
	if (kicker == null) {
	    kicker = new Thread(this);
	    kicker.start();
	}
    }

    /**
     * Stop the applet. The thread will exit because kicker is set to null.
     */
    public void stop() {
	if (kicker != null) {
	    kicker.stop();
	    kicker = null;
	}
    }
}
