/*
 * @(#)InsetTest.java	1.13 96/11/25
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;
import java.applet.*;
     
class QFrame extends Frame {
    public QFrame(String t) {
	super(t);
    }

    public void paint(Graphics g) {
	g.setColor(Color.black);
	Dimension s = size();
	g.drawLine(0, 0, s.width, s.height);
    }

    public boolean handleEvent(Event e) {
	if (e.id == Event.WINDOW_DESTROY) {
	    System.exit(0);
	}
	return super.handleEvent(e);
    }
}

public class InsetTest extends TestApplet {

    Frame f1, f2, f3, f4;
    Dialog d1, d2, d3, d4;

 
    public void init() {
	setLayout(new GridLayout(0,1));
	add(new Button("start"));
    }

    public boolean action(Event evt, Object arg) {
	if ("start".equals(arg)) {
	    showWindows();
	    ((Button)evt.target).setLabel("stop");
	} else if ("stop".equals(arg)) {
	    hideWindows();
	    ((Button)evt.target).setLabel("start");
	}
	return true;
    }

    public void hideWindows() {
	f1.dispose();
	f2.dispose();
	f3.dispose();
	f4.dispose();
	d1.dispose();
	d2.dispose();
	d3.dispose();
	d4.dispose();
    }

    public void showWindows() {
	MenuBar m2;

	int d = 120;
	f1 = new QFrame("f1");
	f2 = new QFrame("f2");
	f3 = new QFrame("f3");
	f4 = new QFrame("f4");

	m2 = new MenuBar();
	m2.add(new Menu("File"));
	f2.setMenuBar(m2);
	f1.reshape(0, 0, d, d);
	f2.reshape(d, 0, d, d);
	f3.reshape(0, d, d, d);
	f4.reshape(d, d, d, d);

	d1 = new PDialog(f1, "d1", false);
	d2 = new PDialog(f2, "d2", false);
	d3 = new PDialog(f3, "d3", false);
	d4 = new PDialog(f4, "d4", false);
	
	d1.reshape(2*d, 0, d, d);
	d2.reshape(3*d, 0, d, d);
	d3.reshape(2*d, d, d, d);
	d4.reshape(3*d, d, d, d);

/*
	Window w1 = new QWindow(f1);
	Window w2 = new QWindow(f2);
	Window w3 = new QWindow(f3);
	Window w4 = new QWindow(f4);

	w1.reshape(4*d, 0, d, d);
	w1.setBackground(Color.white);
	w2.reshape(5*d, 0, d, d);
	w2.setBackground(Color.red);
	w3.reshape(4*d, d, d, d);
	w3.setBackground(Color.green);
	w4.reshape(5*d, d, d, d);
	w4.setBackground(Color.blue);
*/

	f1.show();
	f2.show();
	f3.show();
	f4.show();

	d1.show();
	d2.show();
	d3.show();
	d4.show();

/*
	w1.show();
	w2.show();
	w3.show();
	w4.show();
*/
    }
    public static void main(String args[]) {
	Frame f = new Frame("InsetTest");

	InsetTest insetTest = new InsetTest();
	insetTest.init();

	f.add("Center", insetTest);
	f.resize(120, 120);
	f.show();
    }
}

class PDialog extends Dialog {
    public PDialog(Frame p, String t, boolean m) {
	super(p, t, m);
	setLayout(new FlowLayout());
	add(new Button("string"));
    }

    public void paint(Graphics g) {
	g.setColor(Color.black);
	Dimension s = size();
	g.drawLine(0, 0, s.width, s.height);
    }

}

class QWindow extends Window {
    public QWindow(Frame p) {
	super(p);
    }
    public void paint(Graphics g) {
	g.setColor(Color.black);
	Dimension s = size();
	g.drawLine(0, 0, s.width, s.height);
    }

    public static void main(String args[]) {
	Frame f = new Frame("InsetTest");
	InsetTest insettest = new InsetTest();

	insettest.init();
	insettest.start();

	f.add("Center", insettest);
    }
}
