/*
 * @(#)KeyTest.java	1.19 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;
import java.applet.*;

public class KeyTest extends TestApplet {
    public void init() {
	setLayout(new BorderLayout());
	add("Center", new KeyPanel());
    }

    public static void main(String args[]) {
	Frame f = new Frame("KeyTest");

	f.add("Center", new KeyPanel());
	f.resize(410, 300);
	f.show();
    }
}
class KeyPanel extends KeyCanvas {
    KeyCanvas k1;

    public KeyPanel() {
	super(Color.lightGray);
	setLayout(new BorderLayout());
	centered = false;
	add("Center", k1 = new KeyPanel2(Color.cyan));
    }

    public Insets insets() {
	return new Insets(100, 5, 5, 5);
    }
}

class KeyPanel2 extends KeyCanvas {
    KeyCanvas k1;

    public KeyPanel2(Color c) {
	super(c);
	setLayout(new BorderLayout());
	centered = false;
	add("Center", k1 = new KeyCanvas(Color.white));
    }

    public Insets insets() {
	return new Insets(100, 5, 5, 5);
    }
}


class KeyCanvas extends Panel {
    String	value = "";
    Color	keyColor = Color.black;
    int		clickCount = 0;
    Font	font = new Font("Helvetica", Font.BOLD, 24);
    boolean	centered = true;

    public KeyCanvas(Color c) {
	setBackground(c);
	resize(400, 200);
    }

    public void paint(Graphics g) {
	int cx;
	int cy;

	g.setColor(keyColor);
	g.setFont(font);
	Rectangle bounds = bounds();
	FontMetrics fm = g.getFontMetrics(font);

	cx = ((bounds.width - fm.stringWidth(value))/ 2);
	if (centered) {
	    cy = ((bounds.height - fm.getHeight()) / 2);
	} else {
	    cy = fm.getHeight();
	}

	g.drawString(value, cx, cy);
    }

    void displayKey(int key, int modifiers, boolean pressed) {
	String keyString;

	char s[] = new char[1];

	if (pressed) {
	    keyColor = Color.red;
	} else {
	    keyColor = Color.black;
	}
        switch (key) {
          case Event.ENTER:
              keyString = "Enter";
              break;
          case Event.BACK_SPACE:
              keyString = "BackSpace";
              break;
          case Event.TAB:
              keyString = "Tab";
              break;
          case Event.ESCAPE:
              keyString = "Escape";
              break;
          case Event.DELETE:
              keyString = "Delete";
              break;
          default:
              if ((modifiers&Event.CTRL_MASK) != 0) {
                  s[0] = (char)(key + 'a' - 1);
              } else {
                  s[0] = (char)key;
              }
              keyString = new String(s);
              break;
        }

	value = modifierString(modifiers) + keyString + "[" + key + "]";
	repaint();
    }

    String modifierString(int modifiers) {

	String mstr = "";
	if ((modifiers&Event.CTRL_MASK) != 0) {
	    mstr = mstr+"Ctrl-";
	}
	if ((modifiers & Event.SHIFT_MASK) != 0) {
	    mstr = mstr+"Shift-";
	}
	if ((modifiers & Event.META_MASK) != 0) {
	    mstr = mstr+"Meta-";
	}
	if ((modifiers & Event.ALT_MASK) != 0) {
	    mstr = mstr+"Alt-";
	}

	return mstr;
    }

    void displayKeyAction(Event e, boolean pressed) {
	String keyString;

	if (pressed) {
	    keyColor = Color.red;
	} else {
	    keyColor = Color.black;
	}
	switch (e.key) {
	  case Event.HOME:
	    keyString = "Home";
	    break;
	  case Event.END:
	    keyString = "End";
	    break;
	  case Event.PGUP:
	    keyString = "PageUp";
	    break;
	  case Event.PGDN:
	    keyString = "PageDown";
	    break;
	  case Event.UP:
	    keyString = "Up";
	    break;
	  case Event.DOWN:
	    keyString = "Down";
	    break;
	  case Event.LEFT:
	    keyString = "Left";
	    break;
	  case Event.RIGHT:
	    keyString = "Right";
	    break;
	  case Event.F1:
	    keyString = "F1";
	    break;
	  case Event.F2:
	    keyString = "F2";
	    break;
	  case Event.F3:
	    keyString = "F3";
	    break;
	  case Event.F4:
	    keyString = "F4";
	    break;
	  case Event.F5:
	    keyString = "F5";
	    break;
	  case Event.F6:
	    keyString = "F6";
	    break;
	  case Event.F7:
	    keyString = "F7";
	    break;
	  case Event.F8:
	    keyString = "F8";
	    break;
	  case Event.F9:
	    keyString = "F9";
	    break;
	  case Event.F10:
	    keyString = "F10";
	    break;
	  case Event.F11:
	    keyString = "F11";
	    break;
	  case Event.F12:
	    keyString = "F12";
	    break;
          case Event.PRINT_SCREEN:
            keyString = "PrintScreen";
            break;
          case Event.SCROLL_LOCK:
            keyString = "ScrollLock";
            break;
          case Event.CAPS_LOCK:
            keyString = "CapsLock";
            break;
          case Event.NUM_LOCK:
            keyString = "NumLock";
            break;
          case Event.PAUSE:
            keyString = "Pause";
            break;
          case Event.INSERT:
            keyString = "Insert";
            break;
	  default:
	    keyString = "???";
	    break;
	}
	value = modifierString(e.modifiers) + keyString;
	repaint();
    }

    void displayMouse(Event e) {
	value = modifierString(e.modifiers) + "Button (" + e.x + ", "
	    + e.y + ")";
	switch (e.id) {
	  case Event.MOUSE_DRAG:
	    value = value + "...";
	    break;
	  case Event.MOUSE_DOWN:
	    if (e.target == this) {
	        requestFocus();
	    }
	    keyColor = Color.red;
	    clickCount = e.clickCount;
	    value = value + "[clicks=" + clickCount + "]";
	    break;
	  case Event.MOUSE_UP:
	    keyColor = Color.black;
	    value = value + "[clicks=" + clickCount + "]";
	    break;
	  case Event.MOUSE_MOVE:
	    value = value + "'''";
	    break;
	  default:
	    break;
	}
	repaint();
    }

    public boolean handleEvent(Event e) {
        System.out.println(e);
	switch (e.id) {
	  case Event.WINDOW_DESTROY:
	    System.exit(0);
	    return true;
	  case Event.MOUSE_DOWN:
	  case Event.MOUSE_UP:
	  case Event.MOUSE_MOVE:
	  case Event.MOUSE_DRAG:
	    displayMouse(e);
	    return false;
	  case Event.KEY_PRESS:
	  case Event.KEY_RELEASE:
	    displayKey(e.key, e.modifiers, e.id==Event.KEY_PRESS);
	    return false;
	  case Event.KEY_ACTION:
	  case Event.KEY_ACTION_RELEASE:
	    displayKeyAction(e, e.id==Event.KEY_ACTION);
	    return false;
	  default:
	    return super.handleEvent(e);
	}
    }
}
