/*
 * @(#)LabelTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

/*
 * A test for Label class.
 */
public class LabelTest extends TestApplet {
  Label label, testlabel1, testlabel2;
  GridBagLayout gridbag;
  GridBagConstraints ctrs;
  Button leftalign, centeralign, rightalign, dumpbutton, flipbutton;

  public void init() {
    leftalign = new Button("left align");
    centeralign = new Button("center align");
    rightalign = new Button("right align");
    dumpbutton = new Button("Dump status");
    flipbutton = new Button("Flip text");
    label = new Label("LabelTest", Label.CENTER);
    testlabel1 = new Label();
    testlabel2 = new Label("TestLabel2");
    testlabel1.setText("TestLabel1");

    gridbag = new GridBagLayout();
    ctrs = new GridBagConstraints();

    setLayout(gridbag);
    setFont(new Font("Helvetica", Font.PLAIN, 14));

    ctrs.fill = GridBagConstraints.BOTH;
    ctrs.gridheight = 1;
    ctrs.weighty = 1.0;
    gridbag.setConstraints(leftalign, ctrs);
    add(leftalign);

    ctrs.gridy = 1;
    gridbag.setConstraints(centeralign, ctrs);
    add(centeralign);

    ctrs.gridy = 2;
    gridbag.setConstraints(rightalign, ctrs);
    add(rightalign);

    ctrs.gridy = 3;
    gridbag.setConstraints(dumpbutton, ctrs);
    add(dumpbutton);

    ctrs.gridy = 4;
    gridbag.setConstraints(flipbutton, ctrs);
    add(flipbutton);

    ctrs.gridx = 1;
    ctrs.gridy = 0;
    ctrs.gridwidth = 4;
    ctrs.gridheight = 4;
    ctrs.weightx = 1.0;
    ctrs.weighty = 1.0;
    gridbag.setConstraints(label, ctrs);
    add(label);
  }

  public boolean action(Event evt, Object arg) {
    if ("left align".equals(arg))
      label.setAlignment(Label.LEFT);
    else if ("center align".equals(arg))
      label.setAlignment(Label.CENTER);
    else if ("right align".equals(arg))
      label.setAlignment(Label.RIGHT);
    else if ("Dump status".equals(arg)) {
      print("getAlignment(): " + label.getAlignment());
      print("getText(): " + label.getText());
//      print("paramString(): " + label.paramString());
      print("Label on testlabel1: " + testlabel1.getText());
      print("Label on testlabel2: " + testlabel2.getText());
    } else if ("Flip text".equals(arg)) {
      if (label.getText() == "LabelTest")
	label.setText("NewLabel");
      else label.setText("LabelTest");
      label.validate();
    } else return false;
    return true;
  }
    
    
  public static void main(String argv[]) {
    Frame f = new Frame("LabelTest");
    LabelTest labeltest = new LabelTest();

    labeltest.init();

    f.add("Center", labeltest);
    f.pack();
    f.resize(300, 150);
    f.show();
  }
}
