/*
 * @(#)ListTest.java	1.8 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

/**
 * A test of a Container with BorderLayout.
 */
public class ListTest extends TestApplet {
    List l1;
    List l2;
    Label lbl;

    public void init() {
//	super("ListTest");
	l1 = new List();
	l1.addItem("one");
	l1.addItem("two");
	l1.addItem("three");
	l1.addItem("four");
	l1.addItem("five");
	l1.addItem("six");
	l1.addItem("seven");
	l1.addItem("eight");
	l1.addItem("nine");
	l1.addItem("ten");
	l1.setMultipleSelections(true);
	add("West", l1);

	l2 = new List(4, false);
	l2.addItem("een");
	l2.addItem("twee");
	l2.addItem("drie");
	l2.addItem("vier");
	l2.addItem("vijf");
	l2.addItem("zes");
	l2.addItem("zeven");
	l2.addItem("acht");
	l2.addItem("negen");
	l2.addItem("tien");
	add("Center", l2);

	Panel p = new Panel();
	p.add(new Button("print"));
	p.add(lbl = new Label("--selection--"));
	add("South", p);

	move(200, 100);
//	pack();
	show();
    }

    public boolean handleEvent(Event evt) {
	switch (evt.id) {
	  case Event.LIST_SELECT:
	    print("List select: " + ((Integer)evt.arg).intValue());
	    return true;
	  case Event.LIST_DESELECT:
	    print("List deselect: " + ((Integer)evt.arg).intValue());
	    return true;
	  case Event.WINDOW_DESTROY:
	    System.exit(0);
	    return true;
	  default:
	    return super.handleEvent(evt);
	}
    }

    public boolean action(Event evt, Object arg) {
	if (evt.id == Event.ACTION_EVENT) {
	    if ("print".equals(evt.arg)) {
		print("-- list 1 --");
		String sel[] = l1.getSelectedItems();
		for (int i = 0 ; i < sel.length ; i++) {
		    print(sel[i]);
		}
		print("-- list 2 --");
		sel = l2.getSelectedItems();
		for (int i = 0 ; i < sel.length ; i++) {
		    print(sel[i]);
		}
		print("**************");
	    }
	}

	lbl.setText((String)arg);
	return true;
    }

    public static void main(String args[]) {
	Frame f = new Frame("ListTest");
	ListTest listtest = new ListTest();

	listtest.init();
	listtest.start();

	f.resize(200, 200);
	f.add("Center", listtest);
	f.show();
    }
}
