/*
 * @(#)ListTest2.java	1.9 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;
import java.applet.*;

/**
 * A test of a Container with BorderLayout.
 */
public class ListTest2 extends TestApplet {
    List list;
    TextField text, clearstart, clearend;
    TextField position;

    public void init() {
//	super("ListTest2");

	list = new List();
	list.addItem("one");
	list.addItem("two");
	list.addItem("three");
	list.addItem("four");
	list.addItem("five");
	list.addItem("six");
	list.addItem("seven");
	list.addItem("eight");
	list.addItem("nine");
	list.addItem("ten");
	add("Center", list);

	Panel p = new Panel();
	p.setLayout(new GridLayout(0, 2));
	p.add(new Label("text:"));
	p.add(text=new TextField(20));
	p.add(new Label("position:"));
	p.add(position=new TextField(3));
	p.add(new Label("ClearRange start:"));
	p.add(clearstart = new TextField(3));
	p.add(new Label("ClearRange end:"));
	p.add(clearend = new TextField(3));
	p.add(new Checkbox("multiple"));
	p.add(new Button("add"));
	p.add(new Button("del"));
	p.add(new Button("clear"));
	p.add(new Button("select"));
	p.add(new Button("deselect"));
	p.add(new Button("print"));
	p.add(new Button("clear range"));
	p.add(new Button("print status"));
	add("South", p);

	list.resize(list.minimumSize(6));
	move(200, 100);
	resize(preferredSize());
	show();
    }

    public boolean handleEvent(Event evt) {
	switch (evt.id) {
	  case Event.LIST_SELECT:
	    print("List select: " + ((Integer)evt.arg).intValue());
	    return true;
	  case Event.LIST_DESELECT:
	    print("List deselect: " + ((Integer)evt.arg).intValue());
	    return true;
	  case Event.WINDOW_DESTROY:
	    System.exit(0);
	    return true;
	  default:
	    return super.handleEvent(evt);
	}
    }

    int argToIndex(String arg) {
	int n = list.countItems();

	for (int i = 0; i < n; i++) {
	    if (arg.equals(list.getItem(i))) {
		return i;
	    }
	}
	return -1;
    }

    public boolean action(Event evt, Object arg) {
	if (evt.id == Event.ACTION_EVENT) {
	    if (evt.target instanceof Checkbox) {
		list.setMultipleSelections(((Boolean)arg).booleanValue());
	    } else if ("print".equals(evt.arg)) {
		print("-- list contents --");
		int n = list.countItems();
		for (int i=0; i < n; i++) {
		    print(list.getItem(i));
		}
		print("-- list selected --");		
		String sel[] = list.getSelectedItems();
		for (int i = 0 ; i < sel.length ; i++) {
		    print(sel[i]);
		}
	    } else if ("add".equals(evt.arg)) {
		int pos = -1;

		try {
		    pos = Integer.parseInt(position.getText().trim());
		} catch (Exception e) {
		}
		list.addItem(text.getText(), pos);
	    } else if ("del".equals(evt.arg)) {
	        if (text.getText().length() == 0)
		  if (list.allowsMultipleSelections()) {
		    int indices[] = list.getSelectedIndexes();
		    for(int i=0; i < indices.length; i++)
		      list.delItem(indices[i]-i);
		  } else list.delItem(list.getSelectedIndex());
		else {
		  int index = argToIndex(text.getText());
		  if (index == -1)
		    print("Invalid index");
		  else list.delItem(index);
		}
	    } else if ("select".equals(evt.arg)) {
		int index = argToIndex(text.getText());

		if (index == -1) {
		    print("Invalid index");
		} else {
		    list.select(index);
		}
	    } else if ("deselect".equals(evt.arg)) {
		int index = argToIndex(text.getText());

		if (index == -1) {
		    print("Invalid index");
		} else {
		    list.deselect(index);
		}
	    } else if ("clear".equals(evt.arg)) {
		list.clear();
	    } else if ("clear range".equals(evt.arg)) {
	        int start = Integer.parseInt(clearstart.getText());
	        int end = Integer.parseInt(clearend.getText());
		if (start >= 0 && end < list.countItems() && start <= end)
		  list.delItems(start, end);
		else print("Invalid clear range");
	    } else if ("print status".equals(evt.arg)) {
	        print("Visible rows: " + String.valueOf(list.getRows()));
		print("MakeVisible item 0: ");
		list.makeVisible(0);
		if (!list.isSelected(0))
		  list.select(0);
	    }
	}

	return true;
    }

    public static void main(String args[]) {
	Frame f = new Frame("ListTest2");
	ListTest2 listtest2 = new ListTest2();

	listtest2.init();
	listtest2.start();

	f.resize(600, 200);
	f.add("Center", listtest2);
	f.show();
    }
}
