/*
 * @(#)ListenerTest.java	1.9 97/02/27
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;
import java.awt.event.*;

class SemanticAdapter implements ActionListener, ItemListener, AdjustmentListener {

    String name;
 
    public SemanticAdapter(String name) {
        this.name = name;
    }

    //
    // Action Events
    //
    public void actionPerformed(ActionEvent e) {
        System.out.println("actionPerformed("+name+") : "+e);
    }

    // 
    // Item Events
    //
    public void itemStateChanged(ItemEvent e) {
        System.out.println("itemStateChanged("+name+") : "+e);
    }

    //
    // Adjustment Events
    //
    public void adjustmentValueChanged(AdjustmentEvent e) {
        System.out.println("adjustmentValueChanged("+name+") : "+e);
    }
}

class EventAdapter implements ComponentListener, FocusListener, KeyListener, 
                               MouseListener, MouseMotionListener, WindowListener {
    PopupMenu popup;

    public EventAdapter(PopupMenu popup) {
        this.popup = popup;
    }

    //
    // Component Events
    //
    public void componentResized(ComponentEvent e) {
        System.out.println("componentResized: "+e);
    }
    public void componentMoved(ComponentEvent e) {
        System.out.println("componentMoved: "+e);
    }
    public void componentShown(ComponentEvent e) {
        System.out.println("componentShown: "+e);
    }
    public void componentHidden(ComponentEvent e) {
        System.out.println("componentHidden: "+e);
    }

    //
    // Focus Events
    //
    public void focusGained(FocusEvent e) {
        System.out.println("focusGained: "+e);
    }
    public void focusLost(FocusEvent e) {
        System.out.println("focusLost: "+e);
    }

    //
    // Key Events
    //
    public void keyTyped(KeyEvent e) {
        System.out.println("keyTyped: "+e);
    }
    public void keyPressed(KeyEvent e) {
        System.out.println("keyPressed: "+e);
    }
    public void keyReleased(KeyEvent e) {
        System.out.println("keyReleased: "+e);
    }

    //
    // Mosue Events
    //
    public void mouseClicked(MouseEvent e) {
        System.out.println("mouseClicked: "+e);
    }
    public void mousePressed(MouseEvent e) {
        Component src = e.getComponent();
        if ((src instanceof Canvas ||
             src instanceof Label) && 
            e.isPopupTrigger()) {
            popup.show(e.getComponent(), e.getX(), e.getY());
        } else if (src instanceof LightweightCanvas) {
            src.requestFocus();
        }
        System.out.println("mousePressed: "+e);
    }
    public void mouseDragged(MouseEvent e) {
        System.out.println("mouseDragged: "+e);
    }
    public void mouseReleased(MouseEvent e) {
        System.out.println("mouseReleased: "+e);
    }
    public void mouseEntered(MouseEvent e) {
        System.out.println("mouseEntered: "+e);
    }
    public void mouseMoved(MouseEvent e) {
        System.out.println("mouseMoved: "+e);
    }
    public void mouseExited(MouseEvent e) {
        System.out.println("mouseExited: "+e);
    }

    //
    // Window Events
    //
    public void windowOpened(WindowEvent e) {
        System.out.println("windowOpened: "+e);
    }
    public void windowClosing(WindowEvent e) {
        Window w = e.getWindow();
        System.out.println("windowClosing: "+e);
        w.dispose();
    }
    public void windowClosed(WindowEvent e) {
        System.out.println("windowClosed: "+e);
    }
    public void windowIconified(WindowEvent e) {
        System.out.println("windowIconfied: "+e);
    }
    public void windowDeiconified(WindowEvent e) {
        System.out.println("windowDeiconified: "+e);
    }
    public void windowActivated(WindowEvent e) {
        System.out.println("windowActivated: "+e);
    }
    public void windowDeactivated(WindowEvent e) {
        System.out.println("windowDeactivated: "+e);
    }

}

public class ListenerTest extends TestApplet implements ActionListener {

    EventAdapter eventAdapter;
    SemanticAdapter semAdapter1 = new SemanticAdapter("one");
    SemanticAdapter semAdapter2 = new SemanticAdapter("two");

    Frame parentFrame;

    PopupMenu pm;
    Button b;
    Label l;
    List li;
    Choice ch;
    Checkbox cb;
    ScrollPane sp;
    Adjustable spVadj;
    Adjustable spHadj;
    Canvas cv;
    LightweightCanvas lwc;
    Scrollbar sb;
    Frame f;
    Dialog d;
    Window w;

    TextField tf;
    TextArea txt;

    boolean listenersSet = false;

    public static void setEventAdapters(Component c, EventAdapter adapter) {

        c.addComponentListener(adapter);
        c.addFocusListener(adapter);
        c.addKeyListener(adapter);
        c.addMouseListener(adapter);
        c.addMouseMotionListener(adapter);
        
    }

    public static void removeEventAdapters(Component c, EventAdapter adapter) {
        c.removeComponentListener(adapter);
        c.removeFocusListener(adapter);
        c.removeKeyListener(adapter);
        c.removeMouseListener(adapter);
        c.removeMouseMotionListener(adapter);
       
    }

    public synchronized void addAllListeners() {
        if (listenersSet)
            return;

        setEventAdapters(b, eventAdapter);
        b.addActionListener(semAdapter1);
        b.addActionListener(semAdapter2);

        setEventAdapters(l, eventAdapter);
        
        setEventAdapters(ch, eventAdapter);
        ch.addItemListener(semAdapter1);

        setEventAdapters(cb, eventAdapter);
        cb.addItemListener(semAdapter1);
        cb.addItemListener(semAdapter2);

        setEventAdapters(li, eventAdapter);
        li.addItemListener(semAdapter1);
        li.addActionListener(semAdapter1);

        setEventAdapters(cv, eventAdapter);

        setEventAdapters(lwc, eventAdapter);

        setEventAdapters(tf, eventAdapter);
        tf.addActionListener(semAdapter1);

        setEventAdapters(txt, eventAdapter);

        setEventAdapters(sb, eventAdapter);
        sb.addAdjustmentListener(semAdapter1);

        setEventAdapters(sp, eventAdapter);
        spVadj.addAdjustmentListener(semAdapter1);
        spHadj.addAdjustmentListener(semAdapter1);

        if (f != null) {
            addWindowListeners(f);
        }
        if (d != null) {
            addWindowListeners(d);
        }
        if (w != null) {
            addWindowListeners(w);
        }
        listenersSet = true;
    }

    void addWindowListeners(Window w) {
        setEventAdapters(w, eventAdapter);
        w.addWindowListener(eventAdapter);
    }

    public synchronized void removeAllListeners() {
        if (!listenersSet)
            return;

        removeEventAdapters(b, eventAdapter);
        b.removeActionListener(semAdapter1);
        b.removeActionListener(semAdapter2);

        removeEventAdapters(l, eventAdapter);
        
        removeEventAdapters(ch, eventAdapter);
        ch.removeItemListener(semAdapter1);

        removeEventAdapters(cb, eventAdapter);
        cb.removeItemListener(semAdapter1);
        cb.removeItemListener(semAdapter2);

        removeEventAdapters(li, eventAdapter);
        li.removeItemListener(semAdapter1);
        li.removeActionListener(semAdapter1);

        removeEventAdapters(cv, eventAdapter);

        removeEventAdapters(lwc, eventAdapter);

        removeEventAdapters(tf, eventAdapter);
        tf.removeActionListener(semAdapter1);

        removeEventAdapters(txt, eventAdapter);

        removeEventAdapters(sb, eventAdapter);
        sb.removeAdjustmentListener(semAdapter1);

        removeEventAdapters(sp, eventAdapter);
        spVadj.removeAdjustmentListener(semAdapter1);
        spHadj.removeAdjustmentListener(semAdapter1);

        if (f != null) {
            removeWindowListeners(f);
        }
        if (d != null) {
            removeWindowListeners(d);
        }
        if (w != null) {
            removeWindowListeners(w);
        }

        listenersSet = false;
    }

    void removeWindowListeners(Window w) {
        removeEventAdapters(w, eventAdapter);
        w.removeWindowListener(eventAdapter);
    }
 

    public void init() {
        setLayout(new BorderLayout());

        pm = new PopupMenu();
	MenuItem mi = new MenuItem("New York");
        mi.setActionCommand("Select State");
	mi.addActionListener(semAdapter1);
	pm.add(mi);
	mi = new MenuItem("Alabama...");
	mi.addActionListener(semAdapter1);
	pm.add(mi);
        add(pm);

	eventAdapter = new EventAdapter(pm);

        Panel p = new Panel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(6,6,6,6);
        p.setLayout(gridbag);
        //p.setBackground(Color.blue);
        add("Center", p);

        b = new Button("California");
        b.setActionCommand("Golden State");
        c.gridx = c.gridy = 0;
        gridbag.setConstraints(b, c);
        p.add(b);

        l = new Label("Washington");
        c.gridx++;
        gridbag.setConstraints(l, c);
        p.add(l);

        cb = new Checkbox("Nevada");
        c.gridx++;
        gridbag.setConstraints(cb, c);
        p.add(cb);

        ch = new Choice();
        ch.add("Arizona");
        ch.add("New Mexico");
        ch.add("Texas");
        c.gridx++;
        gridbag.setConstraints(ch, c);
        p.add(ch);

        sb = new Scrollbar(Scrollbar.HORIZONTAL, 0, 10, 0, 100);
        sb.setSize(50, 20);
        c.gridx = 0; c.gridy++;
        gridbag.setConstraints(sb, c);
        p.add(sb);

        tf = new TextField(14);
        c.gridx++;
        gridbag.setConstraints(tf, c);
        p.add(tf);

        txt = new TextArea(6, 12);
        c.gridx++;
        gridbag.setConstraints(txt, c);
        p.add(txt);

        li = new List(4, true);
        li.add("Minnasota");
        li.add("Montana");
        li.add("North Dakota");
        li.add("South Dakota");
        c.gridx++;
        gridbag.setConstraints(li, c);
        p.add(li);

        cv = new Canvas();
        cv.setSize(100, 100);
        cv.setBackground(Color.pink);
        c.gridx = 0; c.gridy++;
        gridbag.setConstraints(cv, c);
        p.add(cv);
        //cv.add(pm);

        lwc = new LightweightCanvas(100, 100);
        c.gridx++;
        gridbag.setConstraints(lwc, c);
        p.add(lwc);

        sp = new ScrollPane();
        spVadj = sp.getHAdjustable();
        spHadj = sp.getVAdjustable();
        Canvas cv2 = new Canvas();
        cv2.setSize(400,400);
        cv2.setBackground(Color.blue);
        sp.add(cv2);
        sp.setSize(100, 100);
        c.gridx++;
        gridbag.setConstraints(sp, c);
        p.add(sp);

        Container pf = this;
        while (pf != null && !(pf instanceof Frame)) 
            pf = pf.getParent();
        if (pf != null) {
            parentFrame = (Frame)pf;
        }

        //
        // Create a panel with buttons to turn the listeners on/off
        //
        Panel p2 = new Panel();
        p2.setLayout(new GridLayout(0, 1));
        Button button = new Button("Add Listeners");
        button.setName("add");
        button.addActionListener(this);
        p2.add(button);
        button = new Button("Remove Listeners");
        button.setName("remove");
        button.addActionListener(this);
        p2.add(button);
        button = new Button("Show Frame");
        button.setName("frame");
        button.addActionListener(this);
        p2.add(button); 
        button = new Button("Show Dialog");
        button.setName("dialog");
        button.addActionListener(this);
        p2.add(button);
        button = new Button("Show Window");
        button.setName("window");
        button.addActionListener(this);
        p2.add(button);
        
        c.gridx++;
        gridbag.setConstraints(p2, c);
        p.add(p2);

        addAllListeners();
    }

    public void actionPerformed(ActionEvent e) {
        Component c = (Component)e.getSource();
        String cmd = c.getName();
        if (cmd.equals("add")) {
            addAllListeners();
        } else if (cmd.equals("remove")) {
            removeAllListeners();
        } else if (cmd.equals("frame")) {
            if (f == null) {
                f = new Frame("Test Frame for Listeners");
                f.setSize(200, 200);
                if (listenersSet) {
                    addWindowListeners(f);
                }
            }
            f.show();
        } else if (cmd.equals("dialog")) {
            if (d == null) {
                d = new Dialog(parentFrame, "Test Dialog for Listeners", false);
                d.setSize(200, 200);
                if (listenersSet) {
                    addWindowListeners(d);
                }
            }
            d.show();
        } else if (cmd.equals("window")) {
            if (w == null) {
                w = new ListenerWindow(parentFrame);
                if (listenersSet) {
                    addWindowListeners(w);
                }
            }
            w.show();
        } 
            
    }
    public static void main(String[] args) {
        Frame f = new Frame("Listener Test");
        ListenerTest test = new ListenerTest();
	f.add("Center", test);

	test.init();
	test.start();

	f.pack();
	f.show();
    }
}

class ListenerWindow extends Window implements ActionListener {

    public ListenerWindow(Frame p) {
        super(p);
        setLayout(new FlowLayout());
        Button b = new Button("Close");
        add(b);
        b.addActionListener(this);
        setSize(100, 100);
    }

    public void actionPerformed(ActionEvent e) {
        dispose();
    }
}


class LightweightCanvas extends Component {

    LightweightCanvas(int w, int h) {
        setSize(w, h);
        setBackground(Color.white);
    }

    public void paint(Graphics g) {
        Rectangle r = getBounds();
        g.setColor(getBackground());

        g.fillRect(0, 0, r.width, r.height);

        g.setColor(Color.black);
        g.drawString("Lightweight", 10, 20);
    }

    public Dimension getPreferredSize() {
        return getSize();
    }
}



