/*
 * @(#)MTGraphicsTest.java	1.2 96/11/26
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;
import java.applet.*;
import java.util.Vector;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class MTGraphicsTest extends TestApplet implements Runnable {
    Vector canvases = new Vector();
    Vector animators = new Vector();
    int numanimators;
    boolean appstarted;		// Applet has had start() called
    boolean running = true;	// User has clicked on run()
    Panel canvaspanel;

    Thread anim;

    /*
     * Choose a color that is not too dark or too bluelike.
     */
    public static Color chooseForeground() {
	int r, g, b;
	do {
	    r = (int) (Math.random() * 255);
	    g = (int) (Math.random() * 255);
	} while (r < 128 && g < 128);
	b = (int) (Math.random() * 255);
	return new Color(r, g, b);
    }

    public void init() {
	String s = getParameter("animators");
	try {
	    numanimators = Integer.parseInt(s);
	} catch (Exception e) {
	    numanimators = 1;
	}

	setLayout(new BorderLayout());

	canvaspanel = new Panel();
	canvaspanel.setLayout(new GridLayout(0, 8, 2, 2));
	s = getParameter("canvases");
	int numcanvases;
	try {
	    numcanvases = Integer.parseInt(s);
	} catch (Exception e) {
	    numcanvases = 4;
	}
	for (int i = 0; i < numcanvases; i++) {
	    addCanvas();
	}
	add("Center", canvaspanel);

	Panel p = new Panel();
	p.add(new Button("start"));
	p.add(new Button("stop"));
	p.add(new Button("more canvases"));
	p.add(new Button("less canvases"));
	p.add(new Button("more threads"));
	p.add(new Button("less threads"));
	p.add(new Button("erase"));
	add("North", p);
	setSize(getPreferredSize());
    }

    private void addCanvas() {
	MTDrawCanvas c = new MTDrawCanvas();
	c.setBackground(Color.blue);
	c.setForeground(chooseForeground());
	canvaspanel.add(c);
	if (animators.size() != 0) {
	    c.init();
	}
	canvases.addElement(c);
    }

    private void removeCanvas() {
	try {
	    MTDrawCanvas c = (MTDrawCanvas) canvases.firstElement();
	    canvases.removeElement(c);
	    canvaspanel.remove(c);
	    c.uninit();
	} catch (NoSuchElementException e) {
	    System.out.println("There are no more MT canvases...");
	}
    }

    public boolean action(Event evt, Object arg) {
	if ("start".equals(arg)) {
	    running = true;
	    if (appstarted) {
		adjustThreads(numanimators);
	    }
	} else if ("stop".equals(arg)) {
	    running = false;
	    adjustThreads(0);
	} else if ("more canvases".equals(arg)) {
	    addCanvas();
	    setSize(getPreferredSize());
	    validate();
	} else if ("less canvases".equals(arg)) {
	    removeCanvas();
	    setSize(getPreferredSize());
	    validate();
	} else if ("more threads".equals(arg)) {
	    numanimators++;
	    if (running && appstarted) {
		adjustThreads(numanimators);
	    }
	    updateStatus();
	} else if ("less threads".equals(arg)) {
	    if (numanimators > 0) {
		numanimators--;
		if (running && appstarted) {
		    adjustThreads(numanimators);
		}
		updateStatus();
	    }
	} else if ("erase".equals(arg)) {
	    Enumeration enum = canvases.elements();
	    while (enum.hasMoreElements()) {
		MTDrawCanvas c = (MTDrawCanvas) enum.nextElement();
		c.erase();
	    }
	}

	return true;
    }

    public synchronized void start() {
	appstarted = true;
	if (running) {
	    adjustThreads(numanimators);
	}
    }

    public synchronized void stop() {
	appstarted = false;
	adjustThreads(0);
	notifyAll();
    }

    public synchronized void adjustThreads(int wantanim) {
	int curanim = animators.size();
	if (curanim == wantanim) {
	    return;
	}
	while (curanim > wantanim) {
	    Thread anim = (Thread) animators.firstElement();
	    animators.removeElement(anim);
	    curanim--;
	}
	while (curanim < wantanim) {
	    Thread anim = new Thread(this);
	    anim.setDaemon(true);
	    animators.addElement(anim);
	    anim.start();
	    curanim++;
	}
    }

    public synchronized void run() {
	Thread me = Thread.currentThread();

	Enumeration enum = canvases.elements();
	while (enum.hasMoreElements()) {
	    MTDrawCanvas c = (MTDrawCanvas) enum.nextElement();
	    c.init();
	}

	updateStatus();
	while (animators.contains(me)) {
	    enum = canvases.elements();
	    while (enum.hasMoreElements()) {
		MTDrawCanvas c = (MTDrawCanvas) enum.nextElement();
		c.draw();
	    }
	    try {
		wait(100);
	    } catch (InterruptedException e) {
		break;
	    }
	}
	updateStatus();

	if (animators.size() == 0) {
	    enum = canvases.elements();
	    while (enum.hasMoreElements()) {
		MTDrawCanvas c = (MTDrawCanvas) enum.nextElement();
		c.uninit();
	    }
	}
    }

    public void updateStatus() {
	showStatus(numanimators+" threads "+
		   ((running && appstarted) ? "running" : "stopped"));
    }

    public static void main(String args[]) {
	Frame f = new MTGraphicsFrame();
	MTGraphicsTest graphicsTest = new MTGraphicsTest();

	f.add("Center", graphicsTest);
	f.show();
	graphicsTest.init();
	graphicsTest.start();
	f.pack();
    }
}

class MTGraphicsFrame extends Frame {
    public MTGraphicsFrame() {
	super("Multithreaded Graphics Test");
    }
    public boolean handleEvent(Event e) {
	if (e.id == Event.WINDOW_DESTROY) {
	    System.exit(0);
	}
	return false;
    }
}
    
class MTDrawCanvas extends Canvas {
    Graphics gr;

    public synchronized void init() {
	uninit();
	gr = getGraphics();
	gr.setXORMode(getBackground());
    }

    public synchronized void uninit() {
	Graphics g = gr;
	gr = null;
	if (g != null) {
	    g.dispose();
	}
    }

    public synchronized void draw() {
	Graphics g = gr;
	Dimension d = size();
	int x1 = (int) (d.width * Math.random());
	int y1 = (int) (d.width * Math.random());
	int x2 = (int) (d.width * Math.random());
	int y2 = (int) (d.width * Math.random());
	g.fillRect(Math.min(x1, x2), Math.min(y1, y2),
		   Math.abs(x2 - x1), Math.abs(y2 - y1));
    }

    public synchronized void erase() {
	Graphics g = gr;
	if (g == null) {
	    g = getGraphics();
	}
	Dimension d = size();
	g.setPaintMode();
	g.setColor(getBackground());
	g.fillRect(0, 0, d.width, d.height);
	g.setColor(getForeground());
	g.setXORMode(getBackground());
	if (gr == null) {
	    g.dispose();
	}
    }

    public Dimension minimumSize() {
	return new Dimension(150, 150);
    }

    public Dimension preferredSize() {
	return new Dimension(150, 150);
    }
}
