/*
 * @(#)MenuBarTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;


public class MenuBarTest extends TestApplet {
  MenuBarFrame mbf;

  public void init() {
    mbf = new MenuBarFrame("MenuBarTest");
    mbf.resize(400, 200);
    mbf.show();
  }

  public static void main(String argv[]) {
    MenuBarFrame mbf = new MenuBarFrame("MenuBarTest");

    mbf.resize(400, 200);
    mbf.show();
  }
}


class MenuBarFrame extends Frame {
  Button bdump, removebutton1, removebutton2;
  MenuBar mb;
  Menu filemenu, editmenu, removemenu1, removemenu2, helpmenu;

  public MenuBarFrame(String s) {
    super(s);
    bdump = new Button("Dump Status");
    removebutton1 = new Button("Remove RMenu1");
    removebutton2 = new Button("Remove RMenu2");

    mb = new MenuBar();
    filemenu = new Menu("File");
    editmenu = new Menu("Edit");
    removemenu1 = new Menu("RMenu1");
    removemenu2 = new Menu("RMenu2");
    helpmenu = new Menu("Help");

    filemenu.add(new MenuItem("Load"));
    filemenu.add(new MenuItem("New"));
    filemenu.add(new MenuItem("Open"));
    filemenu.add(new MenuItem("Close"));
    filemenu.add(new MenuItem("Quit"));

    editmenu.add(new MenuItem("Cut"));
    editmenu.add(new MenuItem("Paste"));
    editmenu.add(new MenuItem("Copy"));
    editmenu.add(new MenuItem("Format"));

    removemenu1.add(new MenuItem("garbage 1"));
    removemenu1.add(new MenuItem("garbage 2"));
    removemenu1.add(new MenuItem("garbage 3"));
    removemenu1.add(new MenuItem("garbage 4"));

    removemenu2.add(new MenuItem("garbage 1"));
    removemenu2.add(new MenuItem("garbage 2"));
    removemenu2.add(new MenuItem("garbage 3"));
    removemenu2.add(new MenuItem("garbage 4"));

    helpmenu.add(new MenuItem("No Help Available"));
    mb.setHelpMenu(helpmenu);

    mb.add(filemenu);
    mb.add(editmenu);
    mb.add(removemenu1);
    mb.add(removemenu2);
    mb.add(helpmenu);

    setMenuBar(mb);

    setLayout(new FlowLayout());
    add(bdump);
    add(removebutton1);
    add(removebutton2);
  }

  public boolean action(Event evt, Object arg) {
    if (evt.target instanceof Button)
      if ("Remove RMenu1".equals(arg)) {
	mb.remove(2);
	removebutton1.disable();
      }
      else if ("Remove RMenu2".equals(arg)) {
	mb.remove(removemenu2);
	removebutton2.disable();
      }
      else if ("Dump Status".equals(arg)) {
	System.out.println("Menus: " + mb.countMenus());
	System.out.println("Menu Names: " + mb.getMenu(0).getLabel());
	System.out.println("Menu Names: " + mb.getMenu(1).getLabel());
	System.out.println("Help Menu: " + mb.getHelpMenu().getLabel());
      } else return false;
    else return false;
    return true;
  }
}
