/*
 * @(#)MenuComponentTest.java	1.3 96/12/06
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;


public class MenuComponentTest extends TestApplet {
  MCFrame mcframe;

  public void init() {
    mcframe = new MCFrame("MenuComponentFrame");
    setLayout(new FlowLayout());
    mcframe.resize(300, 300);
    mcframe.show();
  }
}


class MCFrame extends Frame {
  Font mcfont1, mcfont2, mcfont3;
  MenuBar mb;
  Button bdump;
  Menu filemenu, editmenu, helpmenu;
  MenuItem loaditem, newitem, openitem, cutitem, pasteitem;

  public MCFrame(String s) {
    super(s);

    mcfont1 = new Font("Times", Font.BOLD, 12);
    mcfont2 = new Font("Courier", Font.ITALIC, 12);
    mcfont3 = new Font("adobe", Font.PLAIN, 12);

    mb = new MenuBar();
    mb.setFont(mcfont1);

    filemenu = new Menu("File");
    filemenu.setFont(mcfont2);

    editmenu = new Menu("Edit");
    editmenu.setFont(mcfont2);

    helpmenu = new Menu("Help");
    helpmenu.setFont(mcfont2);

    loaditem = new MenuItem("Load");
    loaditem.setFont(mcfont3);
    newitem = new MenuItem("New");
    newitem.setFont(mcfont3);
    openitem = new MenuItem("Open");
    openitem.setFont(mcfont3);
    filemenu.add(loaditem);
    filemenu.add(newitem);
    filemenu.add(openitem);

    cutitem = new MenuItem("Cut");
    cutitem.setFont(mcfont3);
    pasteitem = new MenuItem("Paste");
    pasteitem.setFont(mcfont3);
    editmenu.add(cutitem);
    editmenu.add(pasteitem);

    helpmenu.add(new MenuItem("No Help Available"));
    mb.setHelpMenu(helpmenu);

    mb.add(filemenu);
    mb.add(editmenu);
    mb.add(helpmenu);

    setMenuBar(mb);

    setLayout(new FlowLayout());
    add(bdump = new Button("Dump MenuComponents Status"));
    bdump.reshape(30, 30, 60, 20);
  }

  public boolean action(Event evt, Object arg) {
    if (evt.target instanceof Button) {
	System.out.println("MenuComponent: MenuBar");
	System.out.println("Parent: " + mb.getParent().getClass().getName());
	System.out.println("Menus: " + mb.countMenus());
	System.out.println("Menu Names: " + mb.getMenu(0).getLabel());
	System.out.println("Menu Names: " + mb.getMenu(1).getLabel());
	System.out.println("Help Menu: " + mb.getHelpMenu().getLabel());
	System.out.println("Font Type: " + mb.getFont().getName() + "\n");
	System.out.println("MenuComponent: File Menu");
	System.out.println("Parent: " + filemenu.getParent().getClass().getName());
	System.out.println("MenuItems: " + filemenu.countItems());
	System.out.println("Font Type: " + filemenu.getFont().getName() + "\n");
	System.out.println("MenuComponent: Edit Menu");
	System.out.println("Parent: " + editmenu.getParent().getClass().getName());
	System.out.println("MenuItems: " + editmenu.countItems());
	System.out.println("Font Type: " + editmenu.getFont().getName() + "\n");
	System.out.println("MenuComponent: Help Menu");
	System.out.println("Parent: " + helpmenu.getParent().getClass().getName());
	System.out.println("MenuItems: " + helpmenu.countItems());
	System.out.println("Font Type: " + helpmenu.getFont().getName() + "\n");
	System.out.println("MenuComponent: Load MenuItem");
	System.out.println("Parent: " + loaditem.getParent().getClass().getName());
	System.out.println("Font Type: " + loaditem.getFont().getName() + "\n");
	System.out.println("ToString Representation: " + mb.toString());
	System.out.println("ToString Representation: " + filemenu.toString());
	System.out.println("ToString Representation: " + loaditem.toString());
    } else return false;
    return true;
  }
}
