/*
 * @(#)MenuItemTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;


public class MenuItemTest extends TestApplet {
  MenuItemFrame mif;

  public void init() {
    mif = new MenuItemFrame("MenuItemTest");

    mif.resize(200, 200);
    mif.show();
  }

  public static void main(String argv[]) {
    new MenuItemFrame("MenuItemTest");
  }
}


class MenuItemFrame extends Frame {
  MenuBar mb;
  Button bdump;
  Menu togglemenu;
  MenuItem enableitem2, enableitem1;

  public MenuItemFrame(String s) {
    super(s);

    mb = new MenuBar();
    togglemenu = new Menu("Toggle");
    enableitem2 = new MenuItem("Enable-Next");
    enableitem1 = new MenuItem("Change This Text");
    enableitem1.setLabel("Enable-Prev");
    togglemenu.add(enableitem2);
    togglemenu.add(enableitem1);
    mb.add(togglemenu);

    setMenuBar(mb);
  }

  public boolean action(Event evt, Object arg) {
    if (evt.target instanceof MenuItem)
      if ("Enable-Next".equals(arg)) {
	if (!enableitem1.isEnabled())
	  enableitem1.enable();
	enableitem2.disable();
	System.out.println("Enabling " + enableitem1.getLabel());
	System.out.println("Disabling " + enableitem2.getLabel()+"\n");
      } else {
	enableitem1.disable();
	enableitem2.enable(!enableitem1.isEnabled());
	System.out.println("Enabling " + enableitem2.getLabel());
	System.out.println("Disabling " + enableitem1.getLabel()+"\n");
      }
    else return false;
    return true;
  }
}
