/*
 * @(#)MenuTest.java	1.16 97/02/05
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

/**
 * A test of a window with menus.
 */
class MTest extends Frame {
    Label lbl;
    Menu  removeMenu;

    public MTest() {
	super("MTest");
	MenuBar mb = new MenuBar();

	Menu m = new Menu("Help");
	m.add("No help...");
	mb.add(m);
	mb.setHelpMenu(m);

	m = new Menu("English");
	m.add(new MenuItem("one"));
	m.add(new MenuItem("two", new MenuShortcut('t')));
	m.add(new MenuItem("three", new MenuShortcut('t', true)));
	m.add(new MenuItem("four"));

	Menu submenu = new Menu("more");
	submenu.add(new MenuItem("five"));
	submenu.add(new MenuItem("six", new MenuShortcut('s', false)));
	m.add(submenu);

	Menu submenu2 = new Menu("more");
	submenu2.add(new MenuItem("seven", new MenuShortcut('s', true)));
	submenu2.add(new MenuItem("eight"));
	submenu.add(submenu2);
	mb.add(m);
	submenu2.setEnabled(false);

	m = new Menu("Nederlands");
	m.add(new MenuItem("een"));
	m.add(new MenuItem("twee"));
	m.add(new MenuItem("drie"));
	m.add(new MenuItem("vier"));
	mb.add(m);

	m = new Menu("Deutsch");
	m.add(new CheckboxMenuItem("eins"));
	m.add(new CheckboxMenuItem("twei"));
	m.add(new CheckboxMenuItem("drie"));
	m.add(new CheckboxMenuItem("vier"));
	mb.add(m);

	m = new Menu("\u2735 Unicode \u2735");
	m.add(new MenuItem("Dingbats: \u2702\u2708\u2713\u272a"));
	m.add(new MenuItem("Symbols: \u2205\u2206\u2207"));
	mb.add(m);

	m = new Menu("Mix");
	MenuItem mi = new MenuItem("disabled 1");
	mi.setEnabled(false);
	m.add(mi);
	mi = new CheckboxMenuItem("disabled 2");
	mi.setEnabled(false);
	m.add(mi);
	m.addSeparator();
	mi = new MenuItem("enabled 1");
	mi.setEnabled(true);
	m.add(mi);
	mi = new CheckboxMenuItem("enabled 2");
	mi.setEnabled(true);
	m.add(mi);

	mb.add(m);

	m = new Menu("Remove");
	m.add(new MenuItem("one"));
	m.add(new MenuItem("two"));
	m.add(new MenuItem("three"));
	m.add(new MenuItem("four"));
	m.add(new MenuItem("five"));
	m.add(new MenuItem("this menu"));
	removeMenu = m;
	mb.add(m);

	m = new Menu("Disabled");
	m.setEnabled(false);
	m.add(new CheckboxMenuItem("disabled one"));
	m.add(new CheckboxMenuItem("disabled two"));
	mb.add(m);

	setMenuBar(mb);

	setLayout(new BorderLayout());
	add("Center", lbl = new Label("The last menu selection will be displayed here.", Label.CENTER));
	setBounds(200, 100, 500, 100);
	show();
    }

    public boolean handleEvent(Event evt) {
	if ((evt.id == Event.ACTION_EVENT) && (evt.target instanceof MenuItem)) {
	    Menu m = (Menu)((MenuItem)evt.target).getParent();
	    if (m == removeMenu) {
		if (((MenuItem)evt.target).getLabel().equals("this menu")) {
		    m.getParent().remove(m);
		} else {
		    m.remove((MenuItem)evt.target);
		}
	    }
	    lbl.setText(evt.target.toString());
	    return true;
	}
	return false;
    }
}

public class MenuTest extends TestApplet {
    Frame frame;
 
    public void init() {
	setLayout(new GridLayout(0,1));
	add(new Button("start"));
    }

    public void destroy() {
	if (frame != null) {
	    frame.dispose();
	}
    }

    public boolean action(Event evt, Object arg) {
	if ("start".equals(arg)) {
	    frame = new MTest();
	    ((Button)evt.target).setLabel("stop");
	} else if ("stop".equals(arg)) {
	    frame.dispose();
	    ((Button)evt.target).setLabel("start");
	}
	return true;
    }

    public static void main(String args[]) {
	Frame f = new Frame("MenuTest");
	MenuTest menutest = new MenuTest();

	menutest.init();
	menutest.start();

	f.add("Center", menutest);
	f.setSize(100, 100);
	f.show();
    }
}
