/*
 * @(#)MenuTest2.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;
import java.applet.*;

/**
 * A test of a window with menus.
 */
class MTest2 extends Frame {
    Label lbl;
    Menu  removeMenu;

    public MTest2() {
	super("MTest2");

	MenuBar mb = new MenuBar();

	Menu m = new Menu("English");
	m.add(new MenuItem("one"));
	m.add(new MenuItem("two"));
	m.add(new MenuItem("three"));
	m.add(new MenuItem("four"));
	mb.add(m);

	setLayout(new BorderLayout());
	add("Center", lbl = new Label("The last menu selection will be displayed here.", Label.CENTER));
	reshape(200, 100, 500, 100);
	show();

	setMenuBar(mb);
    }

    public boolean handleEvent(Event evt) {
	if ((evt.id == Event.ACTION_EVENT) && (evt.target instanceof MenuItem)) {
	    Menu m = (Menu)((MenuItem)evt.target).getParent();
	    if (m == removeMenu) {
		m.remove((MenuItem)evt.target);
	    }
	    lbl.setText(evt.target.toString());
	    return true;
	}
	return false;
    }
}

public class MenuTest2 extends TestApplet {
    Frame frame;
 
    public void init() {
	setLayout(new GridLayout(0,1));
	add(new Button("start"));
    }

    public void destroy() {
	if (frame != null) {
	    frame.dispose();
	}
    }

    public boolean action(Event evt, Object arg) {
	if ("start".equals(arg)) {
	    frame = new MTest2();
	    ((Button)evt.target).setLabel("stop");
	} else if ("stop".equals(arg)) {
	    frame.dispose();
	    ((Button)evt.target).setLabel("start");
	}
	return true;
    }

    public static void main(String args[]) {
	Frame f = new Frame("MenuTest2");
	MenuTest2 menutest = new MenuTest2();

	menutest.init();
	menutest.start();

	f.add("Center", menutest);
	f.resize(100, 100);
	f.show();
    }
}
