/*
 * @(#)MenuTest3.java	1.4 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

class MenuFrame1 extends Frame {
  final static int MENUARRAYSIZE = 10;
  static Boolean flip = Boolean.FALSE;
  int menuindex = 2;
  MenuBar mb;
  Menu menus[] = new Menu[MENUARRAYSIZE];

  public MenuFrame1(String name) {
    super(name);
    mb = new MenuBar();
    menus[0] = new Menu("TestMenu1");
    menus[1] = new Menu("TestMenu2", true);

    menus[0].add(new MenuItem("Load"));
    menus[0].add(new MenuItem("Save"));
    menus[0].add(new MenuItem("Print"));
    menus[0].add(new MenuItem("Quit"));

    menus[1].add("Cut");
    menus[1].add("Paste");
    menus[1].add("Copy");
    menus[1].add("Clear");

    mb.add(menus[0]);
    mb.add(menus[1]);
    setMenuBar(mb);
  }

  public boolean addItem(String menustr, String itemstr) {
    for(int i = 0; ((i < menuindex) & (menuindex < MENUARRAYSIZE)); i++)
      if (menustr.equals(menus[i].getLabel())) {
	menus[i].add(itemstr);
	return true;
      }
    return false;
  }

  public boolean addItem(String menustr, MenuItem menuitem) {
    for(int i = 0; ((i < menuindex) & (menuindex < MENUARRAYSIZE)); i++)
      if (menustr.equals(menus[i].getLabel())) {
	menus[i].add(menuitem);
	return true;
      }
    return false;
  }

  public boolean addMenu(String menustr) {
    menus[menuindex] = new Menu(menustr);
    mb.add(menus[menuindex++]);
    return true;
  }

  public boolean addSep(String menustr) {
    for(int i = 0; ((i < menuindex) & (menuindex < MENUARRAYSIZE)); i++)
      if (menustr.equals(menus[i].getLabel())) {
	menus[i].addSeparator();
	return true;
      }
    return false;
  }

  public boolean removeItem(String menustr, String itemstr) {
    for(int i = 0; ((i < menuindex)  & (menuindex < MENUARRAYSIZE)); i++)
      if (menustr.equals(menus[i].getLabel()))
	for(int j = 0; j < menus[i].countItems(); j++)
	  if (itemstr.equals(menus[i].getItem(j).getLabel())) {
	    if (flip.booleanValue()) {
	      menus[i].remove(menus[i].getItem(j));
	      flip = Boolean.FALSE;
	    } else {
	      menus[i].remove(j);
	      flip = Boolean.TRUE;
	    }
	    return true;
	  }
    return false;
  }
}


public class MenuTest3 extends TestApplet {
  Panel bp;
  MenuFrame1 menuframe;
  TextPanel menufld, itemfld;
  Button additem, addstring, addmenu, addsep, removeitem, dumpstatus;

  public void init() {
    menuframe = new MenuFrame1("TestFrame");
    menufld = new TextPanel("menu: ");
    itemfld = new TextPanel("item: ");
    createButtonPanel();

    setLayout(new GridLayout(3,1));
    add(menufld);
    add(itemfld);
    add(bp);

    menuframe.resize(200, 200);
    menuframe.show();
  }

  public static void main(String argv[]) {
    Frame f = new Frame("MenuTest3");
    MenuTest3 mt = new MenuTest3();
    
    mt.init();
    mt.start();

    f.add("Center", mt);
    f.resize(200, 200);
    f.show();
  }

  public boolean action(Event evt, Object arg) {
    String menustr, itemstr;
    menustr = menufld.getText();
    itemstr = itemfld.getText();
    if ("Add Item".equals(arg))
      menuframe.addItem(menustr, itemstr);
    else if ("Add Menu".equals(arg))
      menuframe.addMenu(menustr);
    else if ("Add Separator".equals(arg))
      menuframe.addSep(menustr);
    else if ("Remove Item".equals(arg))
      menuframe.removeItem(menustr, itemstr);
    else if ("Dump Status".equals(arg))
      print("---- Dump Status ----");
    else return false;
    return true;
  }


  private void createButtonPanel() {
    GridBagLayout gridbag;
    GridBagConstraints gbc;

    bp = new Panel();
    addmenu = new Button("Add Menu");
    additem = new Button("Add Item");
    addsep = new Button("Add Separator");
    removeitem = new Button("Remove Item");
    dumpstatus = new Button("Dump Status");

    setLayout(new GridLayout(5,1));

    bp.add(addmenu);
    bp.add(additem);
    bp.add(addsep);
    bp.add(removeitem);
    bp.add(dumpstatus);
  }
}


class TextPanel extends Panel {
  TextField textfield;

  public TextPanel(String labelstr) {
    setLayout(new FlowLayout());
    add(new Label(labelstr));
    add(textfield = new TextField(20));
  }

  public String getText() {
    return textfield.getText();
  }
}


