/*
 * @(#)PanelLayoutTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;

public class PanelLayoutTest extends Applet
{
  //----- Applet methods

  public void init() {

    Panel quad = new TestPanel(0, Color.orange);
    quad.setLayout(new GridLayout(2, 2));

    quad.add(new DemoCanvas(10, 30, Color.red));
    quad.add(new DemoCanvas(30, 20, Color.green));
    quad.add(new DemoCanvas(10, 30, Color.blue));
    quad.add(new DemoCanvas(30, 20, Color.yellow));

    Panel pair = new TestPanel(20, Color.magenta);
    pair.setLayout(new GridLayout(2, 1));
    pair.add(quad);
    pair.add(new DemoCanvas(100, 100, Color.white));

    add(pair); 

    validate();
  }

}

class TestPanel extends Panel
{

  TestPanel(int border, Color c) {
    this.border = border;
    this.color = c;
  }

  public Insets insets() {
    return new Insets(border, border, border, border);
  }

  public void paint(Graphics g) {
    Dimension s = size();
    Insets i = insets();

    g.setColor(color);
    g.drawRect(0, 0, s.width - 1, s.height - 1);

    g.setColor(color.darker());
    g.drawRect(i.left - 1, i.top - 1,
        s.width - i.left - i.right + 2, s.height - i.top - i.bottom + 2);
  }

  Color color;
  int border;
}

class DemoCanvas extends Canvas
{
  DemoCanvas(int w, int h, Color c) {
    this.c = c;
    d = new Dimension(w, h);
  }

  public void paint(Graphics g) {
    Dimension s = size();
    g.setColor(c);
    g.drawLine(0, 0, s.width, s.height);
    g.drawLine(s.width, 0, 0, s.height);
    g.drawRect(0, 0, s.width-1, s.height-1);
  }

  public Dimension minimumSize() { return d; }
  public Dimension preferredSize() { return d; }

  Color c;
  Dimension d;

}
