/*
 * @(#)PixelTest.java	1.6 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.applet.Applet;
import java.awt.Graphics;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.TextArea;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Color;
import java.awt.Panel;

public class PixelTest extends Applet {
    int mode;
    PixelTestCanvas testcan;
    TextArea textarea;

    public void init() {
	setLayout(new BorderLayout());
	add("North", textarea = new TextArea(5, 60));
	textarea.setEditable(false);
	Panel p = new Panel();
	p.setLayout(new FlowLayout());
	p.add(new Button("Next Test"));
	add("South", p);
	p = new Panel();
	p.setLayout(new FlowLayout());
	p.add(testcan = new PixelTestCanvas(this, 0));
	add("Center", p);
	Dimension psize = preferredSize();
	Dimension size = size();
	if (psize.width > size.width || psize.height > size.height) {
	    resize(Math.max(psize.width, size.width),
		   Math.max(psize.height, size.height));
	}
    }

    void setHelp(String help) {
	textarea.setText(help);
    }

    public boolean action(Event evt, Object arg) {
	if (evt.target instanceof Button) {
	    testcan.nextMode();
	    return true;
	}
	return false;
    }
}

class PixelTestCanvas extends Canvas {
    int mode;
    PixelTest pixeltest;
    static final int NUM_MODES = 8;

    public PixelTestCanvas(PixelTest pt, int m) {
	pixeltest = pt;
	setMode(m);
    }

    void nextMode() {
	if (++mode > NUM_MODES) {
	    mode = 0;
	}
	setMode(mode);
    }

    void setMode(int m) {
	String help = "Error, unknown mode!";
	switch(m) {
	case 0:
	    help =
		"This applet tests for correct pixelization of all Graphics\n"+
		"primitives, starting by verifying lines, and then moving\n"+
		"on to the more complex primitives, testing each primitive\n"+
		"against the previously tested, known working primitives.";
	    break;
	case 1:
	    help =
		"This test verifies the line pixelization.\n"+
		"Each line below should be about as long as the block of\n"+
		"lines next to it.";
	    break;
	case 2:
	    help =
		"This test verifies the rectangle pixelization.  There\n"+
		"should be four rectangles below, with no green pixels\n"+
		"visible.  The black rectangle to their right should have\n"+
		"one single gray rectangle erased out of its upper half.\n";
	    break;
	case 3:
	    help =
		"This test verifies the arc pixelization.\n"+
		"The arcs below should touch the edges of the rectangles\n"+
		"they are drawn on top of, and should not be visible around\n"+
		"the edges of the rectangles drawn on top of them.";
	    break;
	case 4:
	    help =
		"This test verifies the rounded rectangle pixelization.\n"+
		"The roundrects below should touch the edges of the rects\n"+
		"they are drawn on top of, and should not be visible around\n"+
		"the edges of the rectangles drawn on top of them.";
	    break;
	case 5:
	    help =
		"This test verifies the oval pixelization.\n"+
		"The ovals below should touch the edges of the rects\n"+
		"they are drawn on top of, and should not be visible around\n"+
		"the edges of the rectangles drawn on top of them.";
	    break;
	case 6:
	    help =
		"This test verifies the 3D rect pixelization.\n"+
		"The 3D rects below should cover the black rectangle\n"+
		"underneath them and should not be visible around\n"+
		"the edges of the rectangles drawn on top of them.";
	    break;
	case 7:
	    help =
		"This test verifies the negative width/height pixelization.\n"+
		"The figures below are each drawn at the following sizes:\n"+
		"10, 5, 2, 1, 0, -3";
	    break;
	case 8:
	    help =
		"This test verifies the ability to fill and outline various\n"+
		"primitives.  There should be no green pixels outside of\n"+
		"the outlines and no gray pixels inside them.  UL = ovals,\n"+
		"LL = arcs, UR = round rects, LR = rectangles";
	    break;
	}
	pixeltest.setHelp(help);
	mode = mode;
	repaint();
    }

    public Dimension preferredSize() {
	return minimumSize();
    }

    public Dimension minimumSize() {
	return (new Dimension(200, 100));
    }

    public void paint(Graphics g) {
	int r, s;
	int x, y, xend;
	switch (mode) {
	case 0:		// Overview
	    g.drawString("Click on the", 10, 20);
	    g.drawString("button below.", 10, 40);
	    break;
	case 1:		// Lines
	    g.setColor(Color.black);
	    g.drawLine(10, 10, 40, 10);
	    g.drawLine(60, 10, 60, 40);
	    for (int i = 10; i <= 40; i++) {
		g.drawLine(i, 12, i, 40);
		g.drawLine(62, i, 90, i);
	    }
	    break;
	case 2:		// Rects
	    // drawRect
	    g.setColor(Color.green);
	    g.drawLine(10, 10, 10, 40);
	    g.drawLine(10, 40, 40, 40);
	    g.drawLine(40, 40, 40, 10);
	    g.drawLine(40, 10, 10, 10);
	    g.drawRect(60, 10, 30, 30);
	    g.setColor(Color.black);
	    g.drawLine(60, 10, 60, 40);
	    g.drawLine(60, 40, 90, 40);
	    g.drawLine(90, 40, 90, 10);
	    g.drawLine(90, 10, 60, 10);
	    g.drawRect(10, 10, 30, 30);

	    // fillRect
	    g.setColor(Color.green);
	    for (int i = 0; i < 30; i++) {
		g.drawLine(10+i, 60, 10+i, 89);
	    }
	    g.fillRect(60, 60, 30, 30);
	    g.setColor(Color.black);
	    for (int i = 0; i < 30; i++) {
		g.drawLine(60+i, 60, 60+i, 89);
	    }
	    g.fillRect(10, 60, 30, 30);

	    // clearRect
	    g.setColor(Color.black);
	    g.fillRect(100, 0, 50, 100);
	    g.setColor(Color.green);
	    g.fillRect(110, 10, 30, 30);
	    g.clearRect(110, 10, 30, 30);
	    g.clearRect(110, 60, 30, 30);
	    g.setColor(Color.black);
	    g.fillRect(110, 60, 30, 30);
	    break;
	case 3:		// Arcs
	    int arcradii[] = {
		30, 25, 20, 15, 10,
		9, 8, 7, 6, 5, 4,
		3, 2, 1, 0
	    };
	    xend = 5;
	    for (int i = 0; i < arcradii.length; i++) {
		xend += arcradii[i]+2;
	    }
	    x = 5;
	    for (int i = 0; i < arcradii.length; i++) {
		r = arcradii[i];
		g.setColor(Color.black);
		g.fillRect(x, 10, r+1, r+1);
		g.fillRect(x, 60, r, r);
		g.setColor(Color.green);
		g.drawArc(x, 10, r, r, 0, 360);
		g.fillArc(x, 60, r, r, 0, 360);
		x += r+2;
		int x2 = xend - x;
		g.setColor(Color.green);
		g.drawArc(x2, 50-r, r, r, 0, 360);
		g.fillArc(x2, 100-r, r, r, 0, 360);
		g.setColor(Color.black);
		g.fillRect(x2, 50-r, r+1, r+1);
		g.fillRect(x2, 100-r, r, r);
	    }
	    break;
	case 4:		// RoundRects
	    int rrsizes[] = {
		30, 25, 20, 15, 10,
		9, 8, 7, 6, 5, 4,
		3, 2, 1, 0
	    };
	    int rrradii[] = {
		14, 12, 9, 7, 4,
		3, 3, 3, 2, 2, 2,
		1, 1, 0, 0
	    };
	    xend = 5;
	    for (int i = 0; i < rrsizes.length; i++) {
		xend += rrsizes[i]+2;
	    }
	    x = 5;
	    for (int i = 0; i < rrsizes.length; i++) {
		s = rrsizes[i];
		r = rrradii[i];
		g.setColor(Color.black);
		g.fillRect(x, 10, s+1, s+1);
		g.fillRect(x, 60, s, s);
		g.setColor(Color.green);
		g.drawRoundRect(x, 10, s, s, r, r);
		g.fillRoundRect(x, 60, s, s, r, r);
		x += s+2;
		int x2 = xend - x;
		g.setColor(Color.green);
		g.drawRoundRect(x2, 50-s, s, s, r, r);
		g.fillRoundRect(x2, 100-s, s, s, r, r);
		g.setColor(Color.black);
		g.fillRect(x2, 50-s, s+1, s+1);
		g.fillRect(x2, 100-s, s, s);
	    }
	    break;
	case 5:		// Ovals
	    int ovalradii[] = {
		30, 25, 20, 15, 10,
		9, 8, 7, 6, 5, 4,
		3, 2, 1, 0
	    };
	    xend = 5;
	    for (int i = 0; i < ovalradii.length; i++) {
		xend += ovalradii[i]+2;
	    }
	    x = 5;
	    for (int i = 0; i < ovalradii.length; i++) {
		r = ovalradii[i];
		g.setColor(Color.black);
		g.fillRect(x, 10, r+1, r+1);
		g.fillRect(x, 60, r, r);
		g.setColor(Color.green);
		g.drawOval(x, 10, r, r);
		g.fillOval(x, 60, r, r);
		x += r+2;
		int x2 = xend - x;
		g.setColor(Color.green);
		g.drawOval(x2, 50-r, r, r);
		g.fillOval(x2, 100-r, r, r);
		g.setColor(Color.black);
		g.fillRect(x2, 50-r, r+1, r+1);
		g.fillRect(x2, 100-r, r, r);
	    }
	    break;
	case 6:		// 3D rects
	    s = 30;
	    g.setColor(Color.black);
	    g.fillRect(10, 10, s+1, s+1);
	    g.fillRect(10, 60, s, s);
	    g.setColor(Color.green);
	    g.draw3DRect(10, 10, s, s, false);
	    g.fill3DRect(10, 60, s, s, false);
	    g.draw3DRect(60, 10, s, s, false);
	    g.fill3DRect(60, 60, s, s, false);
	    g.setColor(Color.black);
	    g.fillRect(60, 10, s+1, s+1);
	    g.fillRect(60, 60, s, s);
	    break;
	case 7:		// Negatives
	    g.setColor(Color.black);
	    int widths[] = {10, 5, 2, 1, 0, -3};
	    x = 10;
	    for (int i = 0; i < widths.length; i++) {
		y = 10;
		g.drawRect(x, y, widths[i], widths[i]);
		g.fillRect(x+100, y, widths[i], widths[i]);
		y += 15;
		g.drawOval(x, y, widths[i], widths[i]);
		g.fillOval(x+100, y, widths[i], widths[i]);
		y += 15;
		try {
		    g.drawRoundRect(x, y, widths[i], widths[i], 1, 1);
		    g.fillRoundRect(x+100, y, widths[i], widths[i], 1, 1);
		} catch (IllegalArgumentException e) {
		    System.err.println("illegal args for roundrect @width:"+
				       widths[i]);
		}
		y += 15;
		g.drawArc(x, y, widths[i], widths[i], 0, 360);
		g.fillArc(x+100, y, widths[i], widths[i], 0, 360);
		x += 15;
	    }
	    break;
	case 8:		// Outlines for arcs and ovals.
	    int sizes[] = { 40, 25, 10, 5 };
	    x = 10;
	    for (int i = 0; i < sizes.length; i++) {
		s = sizes[i];
		g.setColor(Color.green);
		g.fillOval(x, 5, s, s);
		g.fillRoundRect(x+100, 5, s, s, (s-1)/2, (s-1)/2);
		g.fillArc(x, 55, s, s, 0, 360);
		g.fillRect(x+100, 55, s, s);
		g.setColor(Color.black);
		g.drawOval(x, 5, s, s);
		g.drawRoundRect(x+100, 5, s, s, (s-1)/2, (s-1)/2);
		g.drawArc(x, 55, s, s, 0, 360);
		g.drawRect(x+100, 55, s, s);
		x += s + 2;
	    }
	    break;
	default:
	    g.drawString("Error:", 10, 20);
	    g.drawString("Unknown drawing mode.", 10, 40);
	    break;
	}
    }
}
