/*
 * @(#)PolygonTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
/* awt.Rectangle tests
 * @(#)PolygonTest.java	1.2  11/23/96 04/16/98
 * @author Kevin A. Smtith
 */

import java.awt.*;
import java.applet.Applet;

public class PolygonTest extends Applet
{
    // class variables
    private PolygonCanvas   polygonCanvas;
    private Choice          methodList;
    private TextField       resultValue;
    private TextField       xValue;
    private TextField       yValue;


    public PolygonTest()
    {
       // local variables
       int i;
       String methodNames[];

       // create TestCanvas
       polygonCanvas = new PolygonCanvas();
       methodNames = polygonCanvas.getMethodNames();

       // create Tests control panel
       Panel testPanel = new Panel();
       testPanel.setLayout( new GridLayout(3, 1) );

       // create Methods panel
       Panel tempPanel = new Panel();
       tempPanel.add( new Label("Polygon methods ") );
       tempPanel.add( methodList = new Choice() );
       testPanel.add(tempPanel);

       // initialize choice lists
       for (i = 0; i < methodNames.length; ++i)
          methodList.addItem( methodNames[i] );

       // create information panel
       tempPanel = new Panel();
       tempPanel.add( new Label("X: ") );
       tempPanel.add( xValue = new TextField("100", 3) );
       tempPanel.add( new Label("Y: ") );
       tempPanel.add( yValue = new TextField("100", 3) );
       testPanel.add(tempPanel);

       // creat the result panel
       tempPanel = new Panel();
       tempPanel.add( new Label("Results") );
       tempPanel.add( resultValue = new TextField("N/A", 35) );
       resultValue.setEditable(false);
       testPanel.add(tempPanel);

       // create the applet
       setLayout( new BorderLayout() );
       add("North", testPanel);
       add("Center", polygonCanvas);

    }  // end RectTest()

    public void init()
    {
       resize(400, 400);
    }

    public boolean action(Event evt, Object obj)
    {
       // local variables
       Point pt;
       String tempString;

       if ( (evt.target instanceof Choice) ||
            (evt.target instanceof TextField) )
       {
          pt = new Point( Integer.parseInt( xValue.getText() ),
                          Integer.parseInt( yValue.getText() ) );

          tempString = polygonCanvas.testPolygon(methodList.getSelectedItem(), 
                                                  pt );
          resultValue.setText(tempString);
          return true;
       }
       else
          return super.action(evt, obj);
    }

    public static void main(String args[])
    {
       AppletFrame.startApplet("PolygonTest", "Polygon Tests", args);
    }

}   // end class PolygonTest


class PolygonCanvas extends Canvas
{
    // class variables
    private Polygon pBase;
    private Polygon poly1;
    private Point pt;
    
    private String methodNames[] = 
    {
       "getBoundingBox",
       "inside"
    };

    public PolygonCanvas()
    {
       pBase = new Polygon();
       pBase.addPoint(0, 0);
       pBase.addPoint(200, 0);
       pBase.addPoint(150, 150);
       pBase.addPoint(200, 200);
       pBase.addPoint(50, 200);
       pBase.addPoint(0, 100);
       pBase.addPoint(0, 0);
    }

    public String[] getMethodNames()
    {
       return methodNames;
    }

    public String testPolygon(String command, Point pt)
    {
       // local variables
       String retVal = "N/A";

       // setup the duplicate polygon
       poly1 = new Polygon(pBase.xpoints, pBase.ypoints, pBase.npoints);

       // check the command
       if ( command.equals(methodNames[0]) )
       {
          retVal = pBase.getBoundingBox().toString();
          this.pt = null;
       }
       else if ( command.equals(methodNames[1]) )
       {
          retVal = new Boolean( pBase.inside(pt.x, pt.y) ).toString();
          this.pt = pt;
       }
       else
       {
          this.pt = null;
          retVal = "Unknown method";
       }

       repaint();
       return retVal;
    }  // end testPolygon()

    public void paint(Graphics g)
    {
       // draw base shape
       g.setColor(Color.green);
       g.fillPolygon(pBase);

       // draw point
       if ( pt != null )
       {
          g.setColor(Color.black);
          g.fillOval(pt.x - 2, pt.y - 2, 4, 4);
       }

    }  // end paint()

}   // end class PolygonCanvas

