/*
 * %W% %E%
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public class PopupMenuTest extends TestApplet 
                           implements ActionListener {

    public void init() {
	setLayout(new FlowLayout());
        Button b = new Button("Popup Frame...");
        b.addActionListener(this);
        add(b);
    }

    public void actionPerformed(ActionEvent e) {
        MenuFrame f = new MenuFrame("PopupMenu Test");
        f.show();
    }

    public static void main(String[] args) {
	Frame f = new Frame("PopupMenu Test");
	PopupMenuTest popupTest = new PopupMenuTest();

	popupTest.init();
	popupTest.start();

	f.add("Center", popupTest);
	f.pack();
	f.show();
    }
}

class MsgCanvas extends Canvas {
    String msg;
    PopupMenu popup;

    public MsgCanvas(String msg, PopupMenu popup, Color bg) {
	this.msg = msg;
        this.popup = popup;
        add(popup);
	resize(220, 60);
	setBackground(bg);
        enableEvents(AWTEvent.MOUSE_EVENT_MASK);
    }

    public void paint(Graphics g) {
	Dimension size = size();
	Font f = getFont();
	FontMetrics fm = getFontMetrics(f);
	int msgW = fm.stringWidth(msg);
	int msgH = fm.getHeight();
	int x = (size.width - msgW)/2;
	int y = ((size.height - msgH)/2)+msgH;
	g.setColor(getForeground());
	g.drawString(msg, x, y);
    }

    public void processMouseEvent(MouseEvent e) {
	if (e.isPopupTrigger()) {
	     popup.show(this, e.getX(), e.getY());
	}
	super.processMouseEvent(e);
    }	    
}

class MenuFrame extends Frame implements ActionListener, ItemListener {

    MsgCanvas msg1, msg2;
    PopupMenu popup1, popup2;
    Menu primary;

    public MenuFrame(String title) {
        super(title);
        setLayout(new FlowLayout());

        MenuBar menubar = new MenuBar();
        setMenuBar(menubar);

        Menu m = new Menu("Test");
        m.add("One");
        m.add("Two");
        m.addSeparator();
        m.add(new CheckboxMenuItem("Checkme"));
        menubar.add(m);
        Menu m2 = new Menu("Three");
        m2.add("Four");
        m2.add("Five");
        m.add(m2);
 
        MenuItem mitem;
	popup1 = new PopupMenu();
	popup1.add(mitem = new MenuItem("Red"));
        mitem.addActionListener(this);
	popup1.add(mitem = new MenuItem("Yellow"));
        mitem.addActionListener(this);
	popup1.add(mitem = new MenuItem("Blue"));
        mitem.addActionListener(this);

	msg1 = new MsgCanvas("Popup Canvas Color Menu here.", popup1, Color.blue);
	add(msg1);

	popup2 = new PopupMenu("Text Colors");
        CheckboxMenuItem cbitem = new CheckboxMenuItem("Allow Primaries", true);
        popup2.add(cbitem);
        cbitem.addItemListener(this);
	m = primary = new Menu("Primary");
	m.add(mitem = new MenuItem("Red"));
        mitem.addActionListener(this);
	m.add(mitem = new MenuItem("Yellow"));
        mitem.addActionListener(this);
	m.add(mitem = new MenuItem("Blue"));
        mitem.addActionListener(this);
	popup2.add(m);
	popup2.add(mitem = new MenuItem("Black"));
        mitem.addActionListener(this);
	popup2.add(mitem = new MenuItem("White"));
        mitem.addActionListener(this);

	msg2 = new MsgCanvas("Popup TextColor Menu here.", popup2, Color.gray);
	add(msg2);

        pack();
    }

    public void actionPerformed(ActionEvent e) {
	Color c = null;
        String cmd = e.getActionCommand();
	if (cmd.equals("Red")) {
	    c = Color.red;
	} else if (cmd.equals("Yellow")) {
	    c = Color.yellow;
	} else if (cmd.equals("Blue")) {
	    c = Color.blue;
	} else if (cmd.equals("Black")) {
	    c = Color.black;
	} else if (cmd.equals("White")) {
	    c = Color.white;
	}
	if (c != null) {
	    MenuItem mi = (MenuItem)e.getSource();
	    if (mi.getParent() == popup1) {
		msg1.setBackground(c);
		msg1.repaint();
	    } else {
		msg2.setForeground(c);
		msg2.repaint();
	    }
	}
    }

    public void itemStateChanged(ItemEvent e) {
        primary.setEnabled(e.getStateChange() == ItemEvent.SELECTED);
    }        
}
