/*
 * @(#)PrintingTest.java	1.10 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;
import java.applet.*;
import java.util.*;

public class PrintingTest extends TestApplet {
    Canvas canvas;
    Image image;
    final String PRINTCMD = "Print...";

    public void init() {
//	setTitle("PrintingTest");
	setBackground(Color.white);
	setLayout(new BorderLayout());
	add("North", new Label("Print Output should look identical to Canvas"));
        image = getToolkit().getImage("images/avh.gif");	
	add("Center", canvas = new PrintCanvas(image));	
	add("South", new Button(PRINTCMD));
	reshape(0, 0, 310, 500);
	show();
    }

    public boolean action(Event e, Object arg) {
	if (PRINTCMD.equals(arg)) {
	    Container f = this.getParent();
	    while(!(f instanceof Frame))
		f = f.getParent();
	    if (f == null) { // Create dummy frame when running in Netscape
		f = new Frame();
		((Frame)f).pack();
		((Frame)f).show();
	    }
            PrintJob pj = Toolkit.getDefaultToolkit().getPrintJob((Frame)f, 
			"Printing Test", (Properties)null);

    	    if (pj != null) {
	    	Graphics g;
		Dimension pageDim = pj.getPageDimension();
		int pageRes = pj.getPageResolution();
		boolean lastFirst = pj.lastPageFirst();

	    	print("PrintJob successfully initiated: Page=" +
			pageDim.width + "x" + pageDim.height +
			" Res=" + pageRes + (lastFirst? "last-page-first" : "")	);

	    	g = pj.getGraphics();
	   	if (g != null) {
		    print("Got Graphics handle for Page 1.");
		    canvas.paint(g);
		    g.dispose();
	    	} else {
		    print("Could not get Graphics handle.");
	    	}
	    	print("PrintJob ended.");
	    	pj.end();

    	    } else {
	    	print("PrintJob cancelled.");
	    }
	    return true;
	}
	return false;	
    }

    public static void main(String args[]) {
	Frame f = new Frame("PrintingTest");
	PrintingTest printingTest = new PrintingTest();

	printingTest.init();
	printingTest.start();

	f.resize(400, 400);
	f.add("Center", printingTest);
	f.pack();
	f.show();
    }
}

class PrintCanvas extends Canvas {
    Image image;

    static int CELLW = 100;
    static int CELLH = 100;
    static int MARGIN = 4;
    static int SPAN = CELLW - MARGIN;

    Font times14 = new Font("Times-Roman", Font.PLAIN, 14);
    Font helvetica12 = new Font("Helvetica", Font.PLAIN, 12);
    Font courier10 = new Font("Courier", Font.PLAIN, 10);
    Font timesI12 = new Font("Times-Roman", Font.ITALIC, 12);
    Font helveticaB10 = new Font("Helvetica", Font.BOLD, 10);

    public PrintCanvas(Image img) {
	super();
	image = img;
    }

    public Dimension preferredSize() {
	return new Dimension(300, 675);
    }

    public void paint(Graphics g) {
	int x, y, w, h;
	int i;

	g.setColor(Color.black);
	g.setFont(this.getFont());

	// Cell 1 --> LINES
	x = MARGIN;
	y = MARGIN;
	for (i=0; i < SPAN; i+=10) {
    	    g.drawLine(x, y, x + SPAN, y + i);
	}

	// Cell 2 --> RECTS & CLEARRECT
	x = CELLW + MARGIN;
	g.setColor(Color.blue);
	g.fillRect(x, y, 50, 50);
	g.clearRect(x+10, y+10, 30, 30);

	// Cell 3 --> RECTS
	x = 2*CELLW + MARGIN;
	g.setColor(Color.red);
	g.drawRect(x, y, SPAN, SPAN);

	// Cell 4 --> ROUND RECTS
	x = MARGIN;
	y = CELLH + MARGIN;
	g.setColor(Color.blue);
       	g.drawRoundRect(x, y, SPAN, SPAN, 5, 5);
	g.setColor(Color.black);
	g.drawRoundRect(x+5, y+5, SPAN-10, SPAN-20, 10, 20);
	g.setColor(Color.cyan);
	g.fillRoundRect(x+10, y+10, SPAN-20, SPAN-40, 10, 20);

	// Cell 5 --> 3D RECTS
	x = CELLW + MARGIN;
	g.setColor(Color.black);
	g.draw3DRect(x, y, SPAN-2, SPAN-2, false);
	g.setColor(Color.yellow);
	g.fill3DRect(x+10, y+10, SPAN-24, SPAN-24, false);
	
	// Cell 6 --> RAISED 3D RECTS
	x = 2*CELLW + MARGIN;
	g.setColor(Color.red);
	g.draw3DRect(x, y, SPAN-2, SPAN-2, true);
	g.setColor(Color.green);
	g.fill3DRect(x+10, y+10, SPAN-24, SPAN-24, true);

	// Cell 7 --> OVALS
	x = MARGIN;
	y = 2*CELLH + MARGIN;
	g.setColor(Color.black);
	g.drawOval(x, y+15, SPAN, SPAN - 20);
	g.fillOval(x+15, y+30, SPAN-30, SPAN-50);

	// Cell 8 --> ARCS
	x = CELLW + MARGIN;
	g.setColor(Color.black);
	g.drawArc(x+20, y, SPAN/2, SPAN, 0, 90);
	g.setColor(Color.red);
	g.fillArc(x+20, y, SPAN/2, SPAN, 90, 90);
	g.setColor(Color.black);
	g.drawArc(x+20, y, SPAN/2, SPAN, 180, 90);
	g.setColor(Color.blue);
	g.fillArc(x+20, y, SPAN/2, SPAN, 270, 90);

	// Cell 9 --> POLYGONS
	x = 2*CELLW + MARGIN;
	int xp[] = {x+ 5, x+SPAN-5, x+    20, x+(SPAN/2), x+SPAN-20, x+ 5};
	int yp[] = {y+20, y+    20, y+SPAN-5, y+       5, y+SPAN- 5, y+20};
	g.setColor(Color.blue);
	g.drawPolygon(xp, yp, 6);
	int xfp[] = {x+10, x+SPAN-10, x+    25, x+(SPAN/2), x+SPAN-10, x+10};
	int yfp[] = {y+40, y+     40, y+SPAN-20, y+     20, y+SPAN-20, y+40};
	g.setColor(Color.red);
	g.fillPolygon(new Polygon(xfp, yfp, 6));

	// Cell 10 --> STRINGS 
	x = MARGIN;
	y = 3*CELLH + MARGIN;
	g.setFont(times14);
	g.setColor(Color.blue);
	g.drawString("Times-Roman 14", x+5, y+14);
	g.setFont(helvetica12);
	g.setColor(Color.green);
	g.drawString("Helvetica 12", x+5, y+34);
	g.setFont(courier10);
	g.setColor(Color.black);
	g.drawString("Courier 10", x+5, y+54);
	g.setFont(timesI12);
	g.drawString("Times-Italic 12", x+5, y+74);
	g.setFont(helveticaB10);
	g.drawString("Helvetica-Bold 10", x+5, y+94);
	char c[] = {'c', 'h', 'a', 'r', 'a', 'c', 't', 'a', 'r', 's'};
	g.drawChars(c, 0, 10, x+5, y+114);
	g.drawChars(c, 5, 3, x+5, y+134);

	// Cell 12, 13 --> IMAGES
	x = CELLW + MARGIN;

 	if (image != null) {
	    g.drawImage(image, x+40, y+20, this);
	    g.drawImage(image, x+120, y+20, 30, 80, this);
	    g.drawImage(image, x+40, y+100, Color.blue, this);
	    g.drawImage(image, x+120, y+100, 80, 40, Color.red, this);
	}

	// Cell 14, 15 -> Modes
	x = MARGIN;
	y = 4*CELLH + MARGIN + 50;
	g.translate(x, y);
	g.drawString("translated 0,0 to " + x + "," + y, 30, 20);

	g.setColor(Color.red);
	g.setXORMode(Color.blue);
	for(i=0; i < 80; i+=4) {
	    g.drawRect(30+i, 40+i, 40, 40);
	}

	g.setPaintMode();
	g.clipRect(100, 50, 40, 40);
	for(i=0; i < 80; i+=4) {
	    g.drawRect(90+i, 40+i, 40, 40);
	}
    }
}
