/*
 * @(#)RectTest.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
/* awt.Rectangle tests
 * @(#)RectTest.java	1.3  11/23/96 16:41:29
 * @author Kevin A. Smtith
 */

import java.awt.*;
import java.applet.Applet;

public class RectTest extends Applet
{
    // class variables
    private RectCanvas   rectCanvas;
    private Choice       actionList;
    private TextField    resultValue;
    private TextField    xValue;
    private TextField    yValue;
    private TextField    widthValue;
    private TextField    heightValue;

    private String rectActions[] = 
    {
       "add Integers",
       "add Point",
       "add Rectangle",
       "equals",
       "grow",
       "hashCode",
       "inside",
       "intersect",
       "isEmpty",
       "move",
       "reshape",
       "resize",
       "toString",
       "translate",
       "union"
    };


    public RectTest()
    {
       // local variables
       int i;

       // create Rectangle Tests control panel
       Panel rectPanel = new Panel();
       rectPanel.setLayout( new GridLayout(3, 1) );

       // create action panel
       Panel tempPanel = new Panel();
       tempPanel.add( new Label("Rectangle methods ") );
       tempPanel.add( actionList = new Choice() );
       rectPanel.add(tempPanel);

       // initialize choice lists
       for (i = 0; i < rectActions.length; ++i)
          actionList.addItem( rectActions[i] );

       // create information panel
       tempPanel = new Panel();
       tempPanel.add( new Label("X: ") );
       tempPanel.add( xValue = new TextField("100", 3) );
       tempPanel.add( new Label("Y: ") );
       tempPanel.add( yValue = new TextField("100", 3) );
       tempPanel.add( new Label("Width: ") );
       tempPanel.add( widthValue = new TextField("10", 3) );
       tempPanel.add( new Label("Height: ") );
       tempPanel.add( heightValue = new TextField("10", 3) );
       rectPanel.add(tempPanel);

       // creat the result panel
       tempPanel = new Panel();
       tempPanel.add( new Label("Results") );
       tempPanel.add( resultValue = new TextField("N/A", 35) );
       resultValue.setEditable(false);
       rectPanel.add(tempPanel);

       // create the applet
       setLayout( new BorderLayout() );
       add("North", rectPanel);
       add("Center", rectCanvas = new RectCanvas() );

    }  // end RectTest()

    public void init()
    {
       // note: just to try the rest of the constructors
       Rectangle r = new Rectangle();
       r = new Rectangle( new Point(10, 10) );
       r = new Rectangle( new Dimension(10, 10) );
       r = new Rectangle(10, 10);

       resize(450, 400);
    }

    public boolean action(Event evt, Object obj)
    {
       // local variables
       Rectangle rect;
       String tempString;

       if ( (evt.target instanceof Choice) ||
            (evt.target instanceof TextField) )
       {
          rect = new Rectangle( Integer.parseInt( xValue.getText() ),
                                Integer.parseInt( yValue.getText() ),
                                Integer.parseInt( widthValue.getText() ),
                                Integer.parseInt( heightValue.getText() ) );

          tempString = rectCanvas.testRectangle( actionList.getSelectedItem(), 
                                                 rect );
          resultValue.setText(tempString);
          return true;
       }
       else
          return super.action(evt, obj);
    }

    public static void main(String args[])
    {
       AppletFrame.startApplet("RectTest", "Rectangle Tests", args);
    }

}   // end class RectTest


class RectCanvas extends Canvas
{
    // class variables
    private Dimension rectSize = new Dimension(50, 50);
    private Rectangle rect;
    private Rectangle rect1;
    private Rectangle rect2;
    private Point     pt;
    private Dimension dim;

    public String testRectangle(String command, Rectangle tempRect)
    {
       // local variables
       String retVal = "N/A";

       // setup rectangles
       genBaseRect();
       rect1 = new Rectangle(rect.x, rect.y, rect.width, rect.height);
       pt = new Point(tempRect.x, tempRect.y);
       dim = new Dimension(tempRect.width, tempRect.height);
       rect2 = new Rectangle(pt, dim);

       // check the command
       if ( command.equals("add Integers") )
       {
          rect1.add(tempRect.x, tempRect.y);
          rect2 = null;
          dim = null;
       }   
       else if ( command.equals("add Point") )
       {
          rect1.add(pt);
          rect2 = null;
          dim = null;
       }
       else if ( command.equals("add Rectangle") )
       {
          rect1.add(rect2);
          pt = null;
          dim = null;
       }
       else if ( command.equals("equals") )
       {
          retVal = new Boolean( rect.equals(rect2) ).toString();
          rect1 = null;
          pt = null;
          dim = null;
       }
       else if ( command.equals("grow") )
       {
          rect1.grow(dim.width, dim.height);
          rect2 = null;
          pt = null;
       }
       else if ( command.equals("hashCode") )
       {
          retVal = Integer.toString( rect.hashCode() );
          rect1 = null;
          rect2 = null;
          pt = null;
          dim = null;
       }
       else if ( command.equals("inside") )
       {
          retVal = new Boolean( rect.inside(pt.x, pt.y) ).toString();
          rect1 = null;
          rect2 = null;
          dim = null;
       }
       else if ( command.equals("intersect") )
       {
          rect1 = rect.intersection(rect2);
          dim = null;
          pt = null;
          retVal = new Boolean( rect.intersects( rect2 ) ).toString();
       }
       else if ( command.equals("isEmpty") ) 
       {
          retVal = new Boolean( rect2.isEmpty() ).toString();
          rect1 = null;
          rect2 = null;
          dim = null;
          pt = null;
       }
       else if ( command.equals("move") )
       {
          rect1.move(pt.x, pt.y);
          rect2 = null;
          dim = null;
       }
       else if ( command.equals("reshape") )
       {
          rect1.reshape(pt.x, pt.y, dim.width, dim.height);
          rect2 = null;
       }
       else if ( command.equals("resize") )
       {
          rect1.resize(dim.width, dim.height);
          rect2 = null;
          pt = null;
       }
       else if ( command.equals("toString") )
       {
          retVal = rect.toString();
          rect1 = null;
          rect2 = null;
          pt = null;
          dim = null;
       }
       else if ( command.equals("translate") )
       {
          rect1.translate(pt.x, pt.y);
          pt.x += rect.x;
          pt.y += rect.y;
          rect2 = null;
          dim = null;
       }
       else if ( command.equals("union") )
       {
          rect1 = rect.union(rect2);
          pt = null;
          dim = null;
       }
       else
       {
          rect1 = null;
          rect2 = null;
          pt = null;
          dim = null;
          retVal = "Unknown method";
       }

       repaint();
       return retVal;
    }  // end testRectangle()

    public void paint(Graphics g)
    {
       // draw base rectangle
       g.setColor(Color.green);
       if (rect == null)
          genBaseRect();
       g.drawRect(rect.x, rect.y, rect.width, rect.height);

       // draw Rectangle 1
       if ( rect1 != null )
       {
          g.setColor(Color.blue);
          g.drawRect(rect1.x, rect1.y, rect1.width, rect1.height);
       }
    
       // draw Rectangle 2
       if ( rect2 != null )
       {
          g.setColor(Color.yellow);
          g.drawRect(rect2.x, rect2.y, rect2.width, rect2.height);
       }

       // draw point
       if ( pt != null )
       {
          g.setColor(Color.black);
          g.fillOval(pt.x - 2, pt.y - 2, 4, 4);
       }

       // draw dim
       if ( dim != null )
       {
          g.setColor(Color.red);
          g.drawLine(rect.x, rect.y, rect.x + dim.width, rect.y);
          g.drawLine(rect.x, rect.y, rect.x, rect.y + dim.height);
       }

    }  // end paint()

    private void genBaseRect()
    {
       Point center = new Point( size().width / 2, size().height / 2 );
    
       rect = new Rectangle(center.x - (rectSize.width / 2),
                            center.y - (rectSize.height /2),
                            rectSize.width,
                            rectSize.height);

    }

}   // end class RectCanvas

