/*
 * @(#)ScrollPaneTest.java	1.9 97/02/13
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

class ScrollFrame extends Frame {
    public ScrollFrame() {
	super("ScrollPane Test");
    }
    public boolean handleEvent(Event evt) {
	if (evt.id == Event.WINDOW_DESTROY) {
	    hide();
	    dispose();
	    return true;
	}
	return super.handleEvent(evt);
    }
}

class ScrollController extends Panel {
    TestApplet applet;
    ScrollPane scroller;
    TextField xField, yField;
    Button scrollButton, printButton, newButton;
    Choice sbDisplay;

    public ScrollController(ScrollPane scroller, TestApplet applet) {
	this.scroller = scroller;
	this.applet = applet;

	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();
	setLayout(gridbag);

	printButton = new Button("Print ScrollPane Stats");
	c.gridx = 0;
	c.gridy = 0;
	c.anchor = GridBagConstraints.WEST;
	gridbag.setConstraints(printButton, c);
	add(printButton);

	Panel panel2 = new Panel();
	panel2.setLayout(new FlowLayout());
	panel2.add(scrollButton = new Button("Scroll To:"));
	panel2.add(new Label("X:"));
	panel2.add(xField = new TextField(3));
	panel2.add(new Label("Y:"));
	panel2.add(yField = new TextField(3));
	c.gridy = 1;
	gridbag.setConstraints(panel2, c);
	add(panel2);

	newButton = new Button("Clone ScrollPane in Frame with...");
	c.gridy = 2;
	c.insets = new Insets(15, 0, 0, 0);
	gridbag.setConstraints(newButton, c);
	add(newButton);

	Panel p = new Panel();
	p.setLayout(new FlowLayout());
	p.add(new Label("Scrollbar Display Policy:"));
	sbDisplay = new Choice();
	sbDisplay.addItem("As-Needed");
	sbDisplay.addItem("Always");
	sbDisplay.addItem("Never");
	p.add(sbDisplay);
	c.gridy = 3;
	c.insets = new Insets(0,0,0,0);
	gridbag.setConstraints(p, c);
	add(p);

    }

    public boolean action(Event evt, Object arg) {
	if (evt.target == printButton) {
	    int vsbWidth = scroller.getVScrollbarWidth();
	    int hsbHeight = scroller.getHScrollbarHeight();
	    Adjustable vadj, hadj;
	    applet.print(scroller + " " +
		"vsbWidth="+vsbWidth+" hsbHeight="+hsbHeight);
	    if ((vadj = scroller.getVAdjustable()) != null) {
	        applet.print(vadj.toString());
	    }
	    if ((hadj = scroller.getHAdjustable()) != null) {
	        applet.print(hadj.toString());
	    }
	    return true;
  	} else if (evt.target == newButton) {
	    ScrollFrame f = new ScrollFrame();	
	    ScrollPane sp;
	    if (scroller instanceof ScrollPanePanel) {
		sp = new ScrollPanePanel(sbDisplay.getSelectedIndex());
	        f.add("Center", sp);
	    } else {
		sp = new ScrollCanvas(sbDisplay.getSelectedIndex());
	        f.add("Center", sp);
	    }
	    f.add("East", new ScrollController(sp, applet));
	    f.pack();
	    f.show();
  	    return true;

  	} else if (evt.target == scrollButton) {
	    int x, y;
	    x = (new Integer(xField.getText())).intValue();
	    y = (new Integer(yField.getText())).intValue();
	    scroller.setScrollPosition(x, y);
	    return true;
   	}
	return false;
    }
} 
	    

class UnitButton extends Button {
    public UnitButton(String label, int w, int h) {
	super(label);
	setSize(w, h);		
    }
    public Dimension minimumSize() {
	return getSize();
    }
    public Dimension preferredSize() {
	return getSize();
    }
}

class ScrollPanePanel extends ScrollPane {
    int unitW = 100;
    int unitH = 30;

    public ScrollPanePanel(int sbDisplayPolicy) {
	super(sbDisplayPolicy);
        int rows = 10;
        int cols = 10;
	int hPageUnits = 3;
	int vPageUnits = 3;
	Adjustable hadj = getHAdjustable();
	if (hadj != null)
	    hadj.setUnitIncrement(unitW);
	Adjustable vadj = getVAdjustable();
	if (vadj != null)
  	    vadj.setUnitIncrement(unitH);

	ButtonPanel panel = new ButtonPanel(rows, cols, unitW, unitH);
	add(panel);

	setSize(200, 150);
    }
}

class ButtonPanel extends Panel {
    Dimension max;

    public ButtonPanel(int rows, int cols, int unitW, int unitH) {
	setLayout(new GridLayout(rows, cols));

	int i;
	Button button;
  	for(i = 0 ; i < (rows*cols); i++) {
	    button = new UnitButton("Button "+i, unitW, unitH);
	    add(button);
	}

        max = new Dimension(unitW*cols, unitH*rows);
    }
    public Dimension getMaximumSize() {
System.out.println("ButtonPanel.getMaximumSize: "+max);
        return max;
    }
}

class ScrollCanvas extends ScrollPane {

    public ScrollCanvas(int sbDisplayPolicy) {
	super(sbDisplayPolicy);
	setSize(150, 150);
	DrawCanvas canvas = new DrawCanvas(600, 600);
	add(canvas);
    }
}

class DrawCanvas extends Canvas {
    public DrawCanvas(int w, int h) {
	setSize(w, h);
    }

    public void paint(Graphics g) {
	Rectangle r = g.getClipRect();
	//System.out.println("DrawCanvas.paint: "+r);
	g.setColor(Color.blue);
	g.fillRect(r.x, r.y, r.width-1, r.height-1);
	g.setColor(Color.black);
	g.drawRect(r.x, r.y, r.width-1, r.height-1);
    }
}

public class ScrollPaneTest extends TestApplet {

    public void init() {
	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();
	setLayout(gridbag);

	Label label = new Label("This ScrollPane scrolls a Panel", Label.LEFT);
	c.gridx = c.gridy = 0;
	c.anchor = GridBagConstraints.NORTHWEST;
	gridbag.setConstraints(label, c);
	add(label);

	ScrollPanePanel spanel = new ScrollPanePanel(ScrollPane.SCROLLBARS_AS_NEEDED);
	c.gridy = 1;
	c.weightx = c.weighty = 1;
	gridbag.setConstraints(spanel, c);
	add(spanel);

	ScrollController controller = new ScrollController(spanel, this);
	c.gridx = 1;
	c.weightx = c.weighty = 0;
	gridbag.setConstraints(controller, c);
	add(controller);

	label = new Label("This ScrollPane scrolls a Canvas.  It paints a blue rectangle in exposed areas.", Label.LEFT);
	c.gridx = 0;
	c.gridy = 2;
	c.gridwidth = 2;
	c.insets = new Insets(20, 0, 0, 0);
	c.weightx = c.weighty = 0;
	gridbag.setConstraints(label, c);
	add(label);

	ScrollCanvas scanvas = new ScrollCanvas(ScrollPane.SCROLLBARS_ALWAYS);
	c.gridx = 0;
	c.gridy = 3;
	c.gridwidth = 1;
	c.insets = new Insets(0, 0, 0, 0);
	c.weightx = c.weighty = 1;
	gridbag.setConstraints(scanvas, c);
	add(scanvas);

	controller = new ScrollController(scanvas, this);
	c.gridx = 1;
	c.weightx = c.weighty = 0;
	gridbag.setConstraints(controller, c);
	add(controller);
	
    }

    public static void main(String[] args) {
	ScrollFrame f = new ScrollFrame();
	ScrollPaneTest scrollTest = new ScrollPaneTest();

	scrollTest.init();
	scrollTest.start();

	f.add("Center", scrollTest);
	f.setSize(550, 400);
	f.pack();
	f.show();
    }
} 
