/*
 * @(#)ScrollbarTest.java	1.8 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

class ScrollablePaintCanvas extends Canvas {
    int tx = 20;
    int ty = 100;
    static final int SIZE = 500;

    public void paint(Graphics g) {
	g.translate(-tx, -ty);
	for (int i = 0 ; i < 200 ; i += 20) {
	    g.drawOval(i, i, SIZE - 2*i, SIZE - 2*i);
	}
	g.setColor(Color.yellow);
	g.drawLine(0, SIZE/2, SIZE, SIZE/2);
	g.drawLine(SIZE/2, 0, SIZE/2, SIZE);

	g.setColor(Color.red);
	g.fillOval(SIZE/2 - 20, SIZE/2 - 20, 40, 40);
    }
}

/**
 * A test of a Container with BorderLayout.
 */
public class ScrollbarTest extends TestApplet {
    Scrollbar vert;
    Scrollbar horz;
    Panel scrollpanel, statuspanel;
    TextField vscrollmax, vscrollmin, vscurpos, vscurvis;
    TextField hscrollmax, hscrollmin, hscurpos, hscurvis;
    ScrollablePaintCanvas cv;

    public void init() {
//	super("ScrollbarTest");

        scrollpanel = new Panel();
	scrollpanel.setLayout(new BorderLayout());
	scrollpanel.add("Center", cv = new ScrollablePaintCanvas());
	scrollpanel.add("East", vert = new Scrollbar(Scrollbar.VERTICAL, cv.ty, 100, 0, ScrollablePaintCanvas.SIZE));
	scrollpanel.add("South", horz = new Scrollbar(Scrollbar.HORIZONTAL));
	horz.setValues(cv.tx, 100, 0, ScrollablePaintCanvas.SIZE);
	
	statuspanel = new Panel();
	statuspanel.setLayout(new GridLayout(0,2));
	statuspanel.add(new Label("Horz Current Value: "));
	statuspanel.add(hscurpos = new TextField(3));
	statuspanel.add(new Label("Horz Current Range: "));
	statuspanel.add(hscurvis = new TextField(3));
	statuspanel.add(new Label("HScroll Max: "));
	statuspanel.add(hscrollmax = new TextField(3));
	statuspanel.add(new Label("HScroll Min: "));
	statuspanel.add(hscrollmin = new TextField(3));

	statuspanel.add(new Label("Vert Current Value: "));
	statuspanel.add(vscurpos = new TextField(3));
	statuspanel.add(new Label("Vert Current Range: "));
	statuspanel.add(vscurvis = new TextField(3));
	statuspanel.add(new Label("VScroll Max: "));
	statuspanel.add(vscrollmax = new TextField(3));
	statuspanel.add(new Label("VScroll Min: "));
	statuspanel.add(vscrollmin = new TextField(3));

	hscurpos.setText(String.valueOf(horz.getValue()));
	hscurvis.setText(String.valueOf(horz.getVisible()));
	hscrollmax.setText(String.valueOf(horz.getMaximum()));
	hscrollmin.setText(String.valueOf(horz.getMinimum()));
	vscurpos.setText(String.valueOf(vert.getValue()));
	vscurvis.setText(String.valueOf(vert.getVisible()));
	vscrollmax.setText(String.valueOf(vert.getMaximum()));
	vscrollmin.setText(String.valueOf(vert.getMinimum()));

	setLayout(new BorderLayout());
	add("Center", scrollpanel);
	add("South", statuspanel);
	reshape(100, 200, 300, 250);
	show();
    }

    public boolean handleEvent(Event evt) {
      Scrollbar sb;
	switch (evt.id) {
	  case Event.SCROLL_LINE_UP:
	  case Event.SCROLL_LINE_DOWN:
	  case Event.SCROLL_PAGE_UP:
	  case Event.SCROLL_PAGE_DOWN:
	  case Event.SCROLL_ABSOLUTE:
	    if (evt.target == vert) {
		cv.ty = ((Integer)evt.arg).intValue();
		cv.repaint();
		vscurpos.setText(String.valueOf(vert.getValue()));
		vscurvis.setText(String.valueOf(vert.getVisible()));
		vscrollmax.setText(String.valueOf(vert.getMaximum()));
		vscrollmin.setText(String.valueOf(vert.getMinimum()));
		return true;
	    }
	    sb = (Scrollbar)evt.target;
	    if (sb.getOrientation() == Scrollbar.HORIZONTAL) {
		cv.tx = ((Integer)evt.arg).intValue();
		cv.repaint();
		hscurpos.setText(String.valueOf(horz.getValue()));
		hscurvis.setText(String.valueOf(horz.getVisible()));
		hscrollmax.setText(String.valueOf(horz.getMaximum()));
		hscrollmin.setText(String.valueOf(horz.getMinimum()));
		return true;
	    }
	default:
	    return false;
	}
    }

    public static void main(String args[]) {
	Frame f = new Frame("ScrollbarTest");
	ScrollbarTest scrollbartest = new ScrollbarTest();

	scrollbartest.init();
	scrollbartest.start();

	f.resize(200, 200);
	f.add("Center", scrollbartest);
	f.show();
    }
}
