/*
 * @(#)SetPixelBoundsTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.util.Hashtable;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.awt.image.ImageConsumer;
import java.awt.image.ColorModel;

public class SetPixelBoundsTest {
    public static void main(String argv[]) {
	ImageProducer prod = new PixelBoundsBuster();
	Toolkit tk = Toolkit.getDefaultToolkit();
	Image img = tk.createImage(prod);
	tk.prepareImage(img, 10, 10, null);
	System.exit(0);
    }
}

class PixelBoundsBuster implements ImageProducer {
    ImageConsumer consumer;

    public synchronized void addConsumer(ImageConsumer ic) {
	consumer = ic;
	try {
	    produce(ic);
	} finally {
	    consumer = null;
	}
    }

    void produce(ImageConsumer ic) {
	ic.setDimensions(10, 10);

	ic.setProperties(new Hashtable());

	ColorModel model = ColorModel.getRGBdefault();
	ic.setColorModel(model);

	ic.setHints(ic.TOPDOWNLEFTRIGHT |
		    ic.COMPLETESCANLINES |
		    ic.SINGLEPASS |
		    ic.SINGLEFRAME);

	if (ic != consumer) {
	    // This should rule out the non-ImageRepresentation objects.
	    return;
	}

	byte b[] = new byte[100];
	int  i[] = new int [100];

	trySetPixels(ic, false, 0, 0, 10, 1, model, b, i, 90, 10);
	trySetPixels(ic, false, 0, 0, 10, 1, model, b, i, 90, 100);
	trySetPixels(ic, false, 0, 0, 10, 3, model, b, i, 90, 0);
	trySetPixels(ic, false, 0, 0, 10, 3, model, b, i, 88, 1);
	trySetPixels(ic, true,  0, 0, 10, 1, model, b, i, 91, 10);
	trySetPixels(ic, true,  0, 0, 10, 3, model, b, i, 91, 0);
	trySetPixels(ic, true,  0, 0, 10, 3, model, b, i, 89, 1);
	trySetPixels(ic, true,  0, 0, 10, 1, model, b, i, 100000000, 100);
	trySetPixels(ic, true,  0, 0, 10, 1, model, b, i, (1 << 31) - 1, 0);
	trySetPixels(ic, true,  0, 0, 11, 1, model, b, i, 0, 10);
	trySetPixels(ic, true,  0, 0, 1, 11, model, b, i, 0, 10);

	ic.imageComplete(ic.STATICIMAGEDONE);
    }

    void trySetPixels(ImageConsumer ic, boolean shoulderror,
		      int x, int y, int w, int h, ColorModel model,
		      byte bpix[], int ipix[], int off, int scansize)
    {
	tryBytes(ic, shoulderror, x, y, w, h, model, bpix, off, scansize);
	tryInts (ic, shoulderror, x, y, w, h, model, ipix, off, scansize);
    }

    void tryBytes(ImageConsumer ic, boolean shoulderror,
		  int x, int y, int w, int h, ColorModel model,
		  byte pixels[], int off, int scansize)
    {
	try {
	    ic.setPixels(x, y, w, h, model, pixels, off, scansize);
	} catch (Exception e) {
	    if (shoulderror) {
		System.out.println("BYTE PIXELS PASS (Got Error)");
	    } else {
		System.err.println("Should not have gotten error:");
		e.printStackTrace();
	    }
	    return;
	}
	if (shoulderror) {
	    new Exception("failed to get error").printStackTrace();
	} else {
	    System.out.println("BYTE PIXELS PASS (No Error)");
	}
    }

    void tryInts(ImageConsumer ic, boolean shoulderror,
		 int x, int y, int w, int h, ColorModel model,
		 int pixels[], int off, int scansize)
    {
	try {
	    ic.setPixels(x, y, w, h, model, pixels, off, scansize);
	} catch (Exception e) {
	    if (shoulderror) {
		System.out.println("INT  PIXELS PASS (Got Error)");
	    } else {
		System.err.println("Should not have gotten error:");
		e.printStackTrace();
	    }
	    return;
	}
	if (shoulderror) {
	    new Exception("failed to get error").printStackTrace();
	} else {
	    System.out.println("INT  PIXELS PASS (No Error)");
	}
    }

    public synchronized boolean isConsumer(ImageConsumer ic) {
	return (ic == consumer);
    }

    public void removeConsumer(ImageConsumer ic) {
	if (ic == consumer) {
	    consumer = null;
	}
	return;
    }

    public void startProduction(ImageConsumer ic) {
	addConsumer(ic);
    }

    public void requestTopDownLeftRightResend(ImageConsumer ic) {
	produce(ic);
    }
}
