/*
 * @(#)SwitchMenubarTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;

public class SwitchMenubarTest extends TestApplet {
    Frame frame;
 
    public void init() {
	setLayout(new GridLayout(0,1));
	add(new Button("start"));
    }

    public void destroy() {
	if (frame != null) {
	    frame.dispose();
	}
    }

    public boolean action(Event evt, Object arg) {
	if ("start".equals(arg)) {
	    frame = new SwitchTest();
	    ((Button)evt.target).setLabel("stop");
	} else if ("stop".equals(arg)) {
	    frame.dispose();
	    ((Button)evt.target).setLabel("start");
	}
	return true;
    }

    public static void main(String args[]) {
	Frame f = new Frame("SwitchMenuTest");
	SwitchMenubarTest menutest = new SwitchMenubarTest();

	menutest.init();
	menutest.start();

	f.add("Center", menutest);
	f.resize(100, 100);
	f.show();
    }
}

class SwitchTest extends Frame  {
  MenuBar       main_mbar;
  MenuBar       new_mbar;

  boolean	inMainBar = true;
  Menu          testMenu;
  Menu          newMenu;

  List          list;

  public SwitchTest()
    {
    super("Bug Report");

    list = new List(5, false);
    list.addItem("Item #1");
    list.addItem("Item #2");
    list.addItem("Item #3");
    add("West", list);

    main_mbar = new MenuBar();
    testMenu = new Menu("Old");
    main_mbar.add(testMenu);
    setMenuBar(main_mbar);

    new_mbar = new MenuBar();
    newMenu = new Menu("New");
    new_mbar.add(newMenu);

    resize(150, 200);
    show();
    }

  public boolean handleEvent(Event evt)
    {
    switch (evt.id)
      {
      case Event.LIST_SELECT:
	  if (inMainBar) {
	      remove(main_mbar);
	      setMenuBar(new_mbar);
	  } else {
	      remove(new_mbar);
	      setMenuBar(main_mbar);
	  }
	  inMainBar = !inMainBar;
        return true;
      default:
        return super.handleEvent(evt);
      }
    }
}
