/*
 * @(#)TestApplet.java	1.8 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.applet.*;
import java.awt.*;

public class TestApplet extends Applet {
    OutputHandler outh = new NullOutput();

    public TestApplet() {
    }

    public void print(String s) {
	if (outh instanceof NullOutput) {
	    try {
		AppletContext appCtxt = getAppletContext();

		if (appCtxt != null) {
		    Applet app = getAppletContext().getApplet("Output");

		    if (app != null && app instanceof OutputHandler) {
			outh = (OutputHandler)app;
			outh.setTitle("*" + getClass().getName() + " Output*");
		    }
		}
	    } catch (NullPointerException e) {
	    }
	}
	outh.print(s);
    }

    public void destroy() {
	if (outh instanceof Applet) {
	    ((Applet)outh).destroy();
	}
    }

    public void paint(Graphics g) {
	Dimension s = size();
	g.setColor(Color.black);
	g.drawRect(0, 0, s.width - 1, s.height - 1);
    }

    public Insets insets() {
	return new Insets(2, 2, 2, 2);
    }
}

class NullOutput implements OutputHandler {
    public void setTitle(String s) {
	System.out.println(s);
    }
    public void print(String s) {
	System.out.println(s);
    }
}
