/*
 * @(#)TextAreaTest1.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;


public class TextAreaTest1 extends TestApplet {
  TxtPanel txtpanel1, txtpanel2, txtpanel3, txtpanel4;
  final static int MAXROWS = 15;
  final static int MAXCOLS = 30;
  final static String txtstr2 = "This is Panel2! This is a readonly panel.";
  final static String txtstr4 = "This is Panel4!"; 
  Button dumpbutton;

  public void init() {
    Panel p = new Panel();
    Button dumpbutton = new Button("Dump Status");
    Panel dumppanel = new Panel();
    Panel tfpanel = new Panel();
    txtpanel1 = new TxtPanel();
    txtpanel2 = new TxtPanel(txtstr2);
    txtpanel3 = new TxtPanel(MAXROWS,MAXCOLS);
    txtpanel4 = new TxtPanel(txtstr4, MAXROWS, MAXCOLS);

    tfpanel.setLayout(new GridLayout(2,2));
    tfpanel.add(txtpanel1);
    tfpanel.add(txtpanel2);
    tfpanel.add(txtpanel3);
    tfpanel.add(txtpanel4);

    dumppanel.add(dumpbutton);
    setLayout(new GridLayout(0,1));

    add(dumppanel);
    add(tfpanel);
  }


  public boolean action(Event evt, Object arg) {
    if ("Dump Status".equals(arg)) {
      txtpanel1.dump("Test String1");
      txtpanel2.dump("Test String2");
      txtpanel3.dump("Test String3");
      txtpanel4.dump("Test String4");
      print("toString(): " + toString());
    } else return false;
    return true;
  }


  public static void main(String argv[]) {
    Frame f = new Frame("TextAreaTest");
    TextAreaTest1 textareatest = new TextAreaTest1();

    textareatest.init();
    textareatest.start();

    f.resize(200, 200);
    f.add("Center", textareatest);
    f.show();
  }
}


class TxtPanel extends Panel {
  TextArea txtarea;
  Label label;

  public TxtPanel() {
    txtarea = new TextArea();
    label = new Label("Panel-1");
    resize(preferredSize());
    txtarea.insertText("It was intended that what you type here will\n", 0);
    txtarea.insertText("be echoed in Panel2. That doesnt work yet!\n", 1);
    add(label);
    add(txtarea);
  }

  public TxtPanel(String str) {
    txtarea = new TextArea(str);
    label = new Label("Panel-2");
    txtarea.setEditable(false);
    resize(preferredSize());
    add(label);
    add(txtarea);
  }

  public TxtPanel(int rows, int cols) {
    String txtstr3 = "This is Panel3!";
    txtarea = new TextArea(rows, cols);
    label = new Label("Panel-3");
    txtarea.insertText(txtstr3, 0);
    add(label);
    add(txtarea);
  }

  public TxtPanel(String str, int rows, int cols) {
    txtarea = new TextArea(str, rows, cols);
    label = new Label("Panel-4");
    add(label);
    add(txtarea);
  }

  public void dump(String str) {
    System.out.println("             - A text should be replaced!");
    System.out.println(String.valueOf(txtarea.getRows()));
    System.out.println(String.valueOf(txtarea.getColumns()));
    System.out.println(txtarea.minimumSize().toString());
    System.out.println(txtarea.minimumSize(2,2).toString());
    System.out.println(txtarea.preferredSize().toString());
    System.out.println(txtarea.preferredSize(3,3).toString());
    txtarea.replaceText(str,0,0);
  }
}
