/*
 * @(#)TextComponentTest.java	1.4 97/01/14
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;


public class TextComponentTest extends TestApplet {
  TextFrame tf;

  public void init() {
    tf = new TextFrame();

    setLayout(new FlowLayout());
    tf.pack();
    tf.show();
  }

  public static void main(String argv[]) {
    new TextFrame();
  }
}

    
class TextFrame extends Frame {
  MenuBar mb;
  Panel datapanel, mainpanel;
  int index;
  int curfocus = 0;
  Menu textmenu, ops, edit;
  final static int MAXAREA = 5;
  TextArea ta[] = new TextArea[MAXAREA];
  TextField setfield, startpos, endpos;

  public TextFrame() {
    mb = new MenuBar();
    textmenu = new Menu("TextMenu");
    ops = new Menu("Operations");
    datapanel = new Panel();
    mainpanel = new Panel();
    setfield = new TextField(30);
    startpos = new TextField(3);
    endpos = new TextField(3);

    textmenu.add(new MenuItem("Create"));
    textmenu.add(new MenuItem("Dispose"));
    textmenu.add(new MenuItem("Quit"));

    ops.add(new MenuItem("Select All"));
    ops.add(new MenuItem("Select Pos"));
    ops.add(new MenuItem("Get All Text"));
    ops.add(new MenuItem("Get Select Text"));
    ops.add(new MenuItem("Show Select Pos"));
    ops.add(new MenuItem("Set Text"));
    ops.add(new CheckboxMenuItem("Editable"));

    mb.add(textmenu);
    mb.add(ops);
    
    datapanel.add(new Label("Text:"));
    datapanel.add(setfield);
    datapanel.add(new Label("  Select Start:"));
    datapanel.add(startpos);
    datapanel.add(new Label("  Select End:"));
    datapanel.add(endpos);

    setLayout(new BorderLayout());
    setMenuBar(mb);
    add("South", datapanel);
    add("North", mainpanel);
  }


  public boolean action(Event evt, Object arg) {
    if (evt.id == Event.WINDOW_DESTROY) {
      System.exit(0);
    } else if (evt.id == Event.ACTION_EVENT) {
      if (evt.target instanceof MenuItem)
	if ("Create".equals(arg)) {
	  if (index < MAXAREA) {
	    ta[index] = new TextArea(10, 20);
	    mainpanel.add(ta[index++]);
	    resize(minimumSize());
	    validate();
	  } else System.out.println("ERROR: Reached maximum area creates");
	} else if ("Dispose".equals(arg)) {
	  for(int i = 0; i < index; i++)
	    if (ta[i].gotFocus(evt, arg)) {
	      mainpanel.remove(ta[i]);
	      if (i < (index - 1))
		ta[i] = ta[index--];
	      else index--;
	      resize(minimumSize());
	      validate();
	    }
	} else if ("Quit".equals(arg)) {
	  dispose();
	} else if ("Select All".equals(arg) && ta[curfocus].isEditable()) {
	  ta[curfocus].selectAll();
	} else if ("Select Pos".equals(arg) && ta[curfocus].isEditable()) {
	  int start = Integer.parseInt(startpos.getText());
	  int end = Integer.parseInt(endpos.getText());
	  ta[curfocus].select(start, end);
	} else if ("Set Text".equals(arg) && ta[curfocus].isEditable()) {
	  String s = setfield.getText();
	  ta[curfocus].setText(s);
	} else if ("Get All Text".equals(arg) && ta[curfocus].isEditable()) {
	  System.out.println("String in area " + curfocus + " is: ");
	  System.out.println(ta[curfocus].getText());
	} else if ("Editable".equals(arg)) {
	  if (ta[curfocus].isEditable())
	    ta[curfocus].setEditable(false);
	  else ta[curfocus].setEditable(true);
	} else if ("Show Select Pos".equals(arg) && ta[curfocus].isEditable()) {
	  startpos.setText(String.valueOf(ta[curfocus].getSelectionStart()));
	  endpos.setText(String.valueOf(ta[curfocus].getSelectionEnd()));
	} else if ("Get Select Text".equals(arg) && ta[curfocus].isEditable()) {
	  System.out.println(ta[curfocus].getSelectedText());
	} else return false;
    } else return false;
    return true;
  }
}
