/*
 * @(#)TextFieldTest.java	1.11 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

/**
 * A test of a Container with BorderLayout.
 */
public class TextFieldTest extends TestApplet {
    TextField t1;
    TextField t2;
    TextField t3;

    public void init() {
//	super("TextFieldTest");
	
	setLayout(new BorderLayout());

	Panel p = new Panel();
	p.setLayout(new GridLayout(0, 2));
	p.add(new Label("name"));
	p.add(t1 = new TextField("Beatrix Butterfly"));
	t1.setForeground(Color.blue);

	p.add(new Label("address"));
	p.add(t2 = new TextField("3 Green Fields Lane"));

	p.add(new Label("city"));
	p.add(t3 = new TextField("SunnyHills"));
	t3.setEditable(false);

	add("Center", p);

	p = new Panel();
	Button b;
	p.add(b = new Button("clear"));
	b.setForeground(Color.red);
	p.add(new Button("reset"));
	p.add(new Button("select"));
	p.add(new Button("print"));
	add("South", p);
	move(200, 100);
//	pack();
	show();
    }

    public boolean handleEvent(Event evt) {
	if (evt.id == Event.ACTION_EVENT) {
	    if ("clear".equals(evt.arg)) {
		t1.setText("");
		t2.setText("");
		return true;
	    }
	    if ("reset".equals(evt.arg)) {
		t1.setText("Java Joe");
		t2.setText("123 Whynot St.");
		return true;
	    }
	    if ("select".equals(evt.arg)) {
		t1.selectAll();
		return true;
	    }
	    if ("print".equals(evt.arg)) {
		print("-- values --");
		print("name=" + t1.getText());
		print("address=" + t2.getText());
		print("city=" + t3.getText());
		return true;
	    }
	}
	print(evt.toString());
	return super.handleEvent(evt);
    }

    public static void main(String args[]) {
	Frame f = new Frame("TextFieldTest");
	TextFieldTest textfieldtest = new TextFieldTest();

	textfieldtest.init();
	textfieldtest.start();

	f.resize(300, 200);
	f.add("Center", textfieldtest);
	f.show();
    }
}
