/*
 * @(#)WindowTest.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;


public class WindowTest extends TestApplet {
  WindowFrame windowf;

  public WindowTest() {
    windowf = new WindowFrame("WindowFrame");
    windowf.resize(200, 200);
    windowf.show();
  }

}


class WindowFrame extends Frame {
  TestWindow testwin;
  Panel buttonpanel;
  Button toFront, toBack;

  public WindowFrame(String s) {
    super(s);

    toFront = new Button("Win-front");
    toBack = new Button("Win-back");
    buttonpanel = new Panel();
    buttonpanel.add(toFront);
    buttonpanel.add(toBack);

    setLayout(new BorderLayout());
    add("South", buttonpanel);
    pack();

    testwin = new TestWindow(this);
    testwin.resize(200, 200);
    testwin.reshape(20, 20, 300, 300);
    testwin.show();
  }

  public boolean handleEvent(Event evt) {
    if (evt.id == Event.ACTION_EVENT) {
      if (evt.target == toFront)
	testwin.toFront();
      else if (evt.target == toBack)
	testwin.toBack();
      else if (testwin == null) {
	testwin = new TestWindow(this);
	testwin.resize(200, 200);
	testwin.show();
      }
    }
    return super.handleEvent(evt);
  }
}



class TestWindow extends Window {
  Panel parray[] = new Panel[15];
  Button barray[] = new Button[15];
  TextArea ta = new TextArea(10, 10);
  Scrollbar vscroll = new Scrollbar(Scrollbar.VERTICAL, 10, 100, 0, 300);
  Button contbutton;

  public TestWindow(Frame f) {
    super(f);
    contbutton = new Button("Continue");

    System.out.println("getToolkit: " + getToolkit());
    setLayout(new FlowLayout());
    add(contbutton);
    add(vscroll);
    add(ta);
    for(int i = 0; i<15; i++) {
      barray[i] = new Button();
      parray[i] = new Panel();
      barray[i].setLabel(String.valueOf(i));
      add(barray[i]);
      add(parray[i]);
    }
    //pack();
  }

  public boolean handleEvent(Event evt) {
    if ((evt.id == Event.ACTION_EVENT) && (evt.target == contbutton)) {
      dispose();
    }
    return super.handleEvent(evt);
  }
}
