/*
 * @(#)XORTest.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;
import java.applet.*;

class XORTestCase {
    String name;
    boolean xor1;
    boolean erase;
    boolean xor2;

    public XORTestCase(String n, boolean x1, boolean e, boolean x2) {
	name = n;
	xor1 = x1;
	erase = e;
	xor2 = x2;
    }
}

class XORColorSpec {
    String name;
    Color color;

    public XORColorSpec(String n, Color c) {
	name = n;
	color = c;
    }
}

public class XORTest extends Applet {
    static XORTestCase testcases[] = {
	new XORTestCase("Draw Solid", false, false, true),
	new XORTestCase("Draw XOR", true, false, true),
	new XORTestCase("XOR twice (erase)", true, true, true),
	new XORTestCase("XOR erases Solid", false, true, true),
	new XORTestCase("Solid erases XOR", true, true, false)
    };
    static XORColorSpec colors[] = {
	new XORColorSpec("red", Color.red),
	new XORColorSpec("green", Color.green),
	new XORColorSpec("blue", Color.blue),
	new XORColorSpec("yellow", Color.yellow),
	new XORColorSpec("cyan", Color.cyan),
	new XORColorSpec("magenta", Color.magenta),
	new XORColorSpec("orange", Color.orange),
	new XORColorSpec("pink", Color.pink),
	new XORColorSpec("gray", Color.gray),
	new XORColorSpec("white", Color.white),
	new XORColorSpec("black", Color.black)
    };

    XORCards	cards;
    Choice	cardchoice;
    Choice	fgchoice;
    Choice	bgchoice;
    int fgindex;
    int bgindex;
    
    public void init() {
	setLayout(new BorderLayout());
	add("Center", cards = new XORCards());
	Panel p = new Panel();
	p.setLayout(new GridLayout(0, 2));
	p.add(new Button("next"));
	p.add(new Button("previous"));
	p.add(new Label("drawing mode:", Label.RIGHT));

	p.add(cardchoice = new Choice());
	for (int i = 0; i < testcases.length; i++) {
	    cardchoice.addItem(testcases[i].name);
	}

	p.add(new Label("foreground color:", Label.RIGHT));
	p.add(fgchoice = new Choice());
	p.add(new Label("background color:", Label.RIGHT));
	p.add(bgchoice = new Choice());
	for (int i = 0; i < colors.length; i++) {
	    fgchoice.addItem(colors[i].name);
	    bgchoice.addItem(colors[i].name);
	}
	fgchoice.select("green");
	bgchoice.select("blue");
	fgindex = fgchoice.getSelectedIndex();
	bgindex = bgchoice.getSelectedIndex();
	cards.setBackground(colors[bgindex].color);
	add("North", p);
	Dimension psize = preferredSize();
	Dimension size = size();
	if (psize.width < size.width || psize.height < size.height) {
	    resize(Math.max(psize.width, size.width),
		   Math.max(psize.height, size.height));
	}
    }
    public boolean action(Event evt, Object arg) {
	if (evt.target == cardchoice) {
	    ((CardLayout)cards.getLayout()).show(cards,(String)arg);
	} else if (evt.target == fgchoice) {
	    fgindex = fgchoice.getSelectedIndex();
	} else if (evt.target == bgchoice) {
	    bgindex = bgchoice.getSelectedIndex();
	    cards.setBackground(colors[bgindex].color);
	} else {
	    int index = cardchoice.getSelectedIndex();
	    int count = cardchoice.countItems();
	    if ("next".equals(arg)) {
		((CardLayout)cards.getLayout()).next(cards);
		if (++index >= count) {
		    index = 0;
		}
	    } else if ("previous".equals(arg)) {
		((CardLayout)cards.getLayout()).previous(cards);
		if (--index < 0) {
		    index = count - 1;
		}
	    }
	    cardchoice.select(index);
	}

	return true;
    }

    public static void main(String args[]) {
	XORFrame f = new XORFrame();
	XORTest graphicsTest = new XORTest();

	graphicsTest.init();
	f.add("Center", graphicsTest);
	f.resize(300, 300);
	f.show();
    }
}

class XORFrame extends Frame {
    public XORFrame() {
	super("XOR Test");
    }
    public boolean handleEvent(Event e) {
	if (e.id == Event.WINDOW_DESTROY) {
	    System.exit(0);
	}
	return false;
    }
}
    
class XORCards extends Panel {
    public XORCards() {
	setLayout(new CardLayout());
	XORTestCase testcases[] = XORTest.testcases;
	for (int i = 0; i < testcases.length; i++) {
	    add(testcases[i].name, new XORCanvas(testcases[i]));
	}
    }
}


class XORCanvas extends Canvas {
    XORTestCase testcase;
    public XORCanvas(XORTestCase tc) {
	testcase = tc;
    }

    public void paint(Graphics g) {
	XORTest p = (XORTest) getParent().getParent();
	Color bg = p.colors[p.bgindex].color;
	Color fg = p.colors[p.fgindex].color;
	g.setColor(bg);
	g.fillRect(0, 0, size().width, size().height);
	g.setColor(fg);
	g.setPaintMode();
	painttest(g, false);
	g.translate(120, 0);
	if (testcase.xor1) {
	    g.setXORMode(bg);
	}
	painttest(g, false);
	if (testcase.erase) {
	    getToolkit().sync();
	    try {
		Thread.sleep(100);
	    } catch (InterruptedException e) {
	    }
	    if (testcase.xor2) {
		g.setXORMode(bg);
	    } else {
		g.setColor(bg);
		g.setPaintMode();
	    }
	    painttest(g, !testcase.xor2);
	}
    }

    public void painttest(Graphics g, boolean erase) {
	int index = 0;
	int y = 10;
	while (index < allprimitives.length) {
	    int x = 10;
	    for (int j = 0; j < 5 && index < allprimitives.length; j++) {
		paintprimitive(g, index, x, y, erase);
		index++;
		x += 20;
	    }
	    y += 20;
	}
    }

    public Dimension preferredSize() {
	return minimumSize();
    }

    public Dimension minimumSize() {
	return new Dimension((5 * 20 + 20) * 2,
			     ((allprimitives.length + 4) / 5) * 20 + 20);
    }

    static final int DRAWLINE		= 0;
    static final int DRAWRECT		= 1;
    static final int FILLRECT		= 2;
    static final int CLEARRECT		= 3;
    static final int DRAWROUNDRECT	= 4;
    static final int FILLROUNDRECT	= 5;
    static final int DRAW3DRECT		= 6;
    static final int FILL3DRECT		= 7;
    static final int DRAWOVAL		= 8;
    static final int FILLOVAL		= 9;
    static final int DRAWARC		= 10;
    static final int FILLARC		= 11;
    static final int DRAWPOLYGON	= 12;
    static final int FILLPOLYGON	= 13;
    static final int DRAWSTRING		= 14;

    static final int allprimitives[] = {
	DRAWLINE, DRAWRECT, FILLRECT, CLEARRECT,
	DRAWROUNDRECT, FILLROUNDRECT, DRAW3DRECT, FILL3DRECT,
	DRAWOVAL, FILLOVAL, DRAWARC, FILLARC,
	DRAWPOLYGON, FILLPOLYGON, DRAWSTRING
    };

    public void paintprimitive(Graphics g, int which, int x, int y,
			       boolean erase) {
	Color c;
	switch (which) {
	case DRAWLINE:
	    g.drawLine(x, y, x + 15, y + 15);
	    break;
	case DRAWRECT:
	    g.drawRect(x, y, 15, 15);
	    break;
	case FILLRECT:
	    g.fillRect(x, y, 15, 15);
	    break;
	case CLEARRECT:
	    g.clearRect(x, y, 15, 15);
	    break;
	case DRAWROUNDRECT:
	    g.drawRoundRect(x, y, 15, 15, 8, 8);
	    break;
	case FILLROUNDRECT:
	    g.fillRoundRect(x, y, 15, 15, 8, 8);
	    break;
	case DRAW3DRECT:
	    if (erase) {
		g.drawRect(x, y, 15, 7);
		g.drawRect(x, y + 10, 15, 7);
	    } else {
		g.draw3DRect(x, y, 15, 7, false);
		g.draw3DRect(x, y + 10, 15, 7, true);
	    }
	    break;
	case FILL3DRECT:
	    if (erase) {
		g.fillRect(x, y, 15, 7);
		g.fillRect(x, y + 10, 15, 7);
	    } else {
		g.fill3DRect(x, y, 15, 7, false);
		g.fill3DRect(x, y + 10, 15, 7, true);
	    }
	    break;
	case DRAWOVAL:
	    g.drawOval(x, y, 15, 15);
	    break;
	case FILLOVAL:
	    g.fillOval(x, y, 15, 15);
	    break;
	case DRAWARC:
	    g.drawArc(x, y, 15, 15, 0, 300);
	    break;
	case FILLARC:
	    g.fillArc(x, y, 15, 15, 0, 300);
	    break;
	case DRAWPOLYGON:
	    int xdp[] = {0, 15, 0, 15, 0, 15};
	    int ydp[] = {0, 0, 8, 15, 15, 8};
	    for (int i = 0; i < xdp.length; i++) {
		xdp[i] += x;
		ydp[i] += y;
	    }
	    g.drawPolygon(xdp, ydp, xdp.length);
	    break;
	case FILLPOLYGON:
	    int xfp[] = {0, 15, 0, 15, 0, 15};
	    int yfp[] = {0, 0, 8, 15, 15, 8};
	    for (int i = 0; i < xfp.length; i++) {
		xfp[i] += x;
		yfp[i] += y;
	    }
	    g.fillPolygon(xfp, yfp, xfp.length);
	    break;
	case DRAWSTRING:
	    g.drawString("Hi", x, y+15);
	    break;
	}
    }
}
