/*
 * @(#)DrawSurfaceTest.java	1.7 96/12/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.Color;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
import sun.awt.DrawingSurfaceInfo;
import sun.awt.DrawingSurface;

/**
 * The DrawSurfaceTest does not implement a complete test by itself.
 * It is the common abstract superclass for the platform-dependent
 * native DrawingSurface access classes.  The actual tests are
 * stored in the platform source directories:
 *
 * src/solaris/test/awt/drawsurface
 * src/win32/test/awt/drawsurface
 *
 * Those directories contain complete makefiles to build the tests
 * and exploit the interface to perform native drawing in a portable
 * way.
 *
 * @version	1.7, 12/23/96
 * @author	Jim Graham
 */
public abstract class DrawSurfaceTest extends Canvas
    implements Runnable, WindowListener
{
    static final float MINDELTA = 3.0f;
    static final float MAXDELTA = 10.0f;
    static final float PREFSIZE = 500.0f;

    Thread anim;

    public DrawSurfaceTest() {
	setBackground(Color.black);
    }

    public Dimension getPreferredSize() {
	return new Dimension((int) PREFSIZE, (int) PREFSIZE);
    }

    public Dimension getMinimumSize() {
	return new Dimension(100, 100);
    }

    public void windowOpened(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {System.exit(0);}
    public void windowClosed(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {stop();}
    public void windowDeiconified(WindowEvent e) {start();}
    public void windowActivated(WindowEvent e) {}
    public void windowDeactivated(WindowEvent e) {}

    public void addNotify() {
	super.addNotify();
	Container p = getParent();
	while (p != null) {
	    if (p instanceof Frame) {
		((Frame) p).addWindowListener(this);
		break;
	    }
	}
    }

    public void removeNotify() {
	super.removeNotify();
	Container p = getParent();
	while (p != null) {
	    if (p instanceof Frame) {
		((Frame) p).removeWindowListener(this);
		break;
	    }
	}
    }

    public synchronized void start() {
	anim = new Thread(this);
	anim.start();
    }

    public synchronized void stop() {
	anim = null;
	notifyAll();
    }

    public synchronized void run() {
	Thread me = Thread.currentThread();
	try {
	    bezierLoop(me);
	} finally {
	    if (anim == me) {
		anim = null;
	    }
	}
    }

    public void increment(float ctrlpts[], float deltas[], int i, int dim) {
	ctrlpts[i] += deltas[i];
	if (ctrlpts[i] < 0) {
	    ctrlpts[i] = 0;
	    deltas[i] = (float) Math.random() * MINDELTA + MAXDELTA;
	} else if (ctrlpts[i] > (float) dim) {
	    ctrlpts[i] = (float) dim;
	    deltas[i] = (float) Math.random() * MINDELTA - MAXDELTA;
	}
    }

    public abstract DrawSurfaceTracker getTracker(DrawingSurfaceInfo dsi);

    Dimension prevsize = null;
    Image img = null;
    DrawSurfaceTracker imagedst = null;
    float ctrlpts[] = {
	0.0f,		0.0f,
	0.0f,		PREFSIZE,
	PREFSIZE,	PREFSIZE,
	PREFSIZE,	0.0f,
    };
    float deltas[] = {
	+MINDELTA, +MAXDELTA,
	+MAXDELTA, -MINDELTA,
	-MINDELTA, -MAXDELTA,
	-MAXDELTA, +MINDELTA,
    };

    public void bezierLoop (Thread me) {
	Dimension d = getSize();
	DrawingSurfaceInfo dsi;
	dsi = ((DrawingSurface) getPeer()).getDrawingSurfaceInfo();
	DrawSurfaceTracker canvasdst = getTracker(dsi);

	while (anim == me) {
	    d = getSize();
	    if (!d.equals(prevsize)) {
		Image img2 = createImage(d.width, d.height);
		if (img != null) {
		    Graphics g = img2.getGraphics();
		    g.drawImage(img, 0, 0, null);
		    img.flush();
		    g.dispose();
		}
		img = img2;
		dsi = ((DrawingSurface) img).getDrawingSurfaceInfo();
		imagedst = getTracker(dsi);
	    }
	    prevsize = d;
	    int x1 = (int) Math.min(Math.min(ctrlpts[0],ctrlpts[2]),
				    Math.min(ctrlpts[4],ctrlpts[6])) - 2;
	    int y1 = (int) Math.min(Math.min(ctrlpts[1],ctrlpts[3]),
				    Math.min(ctrlpts[5],ctrlpts[7])) - 2;
	    int x2 = (int) Math.max(Math.max(ctrlpts[0],ctrlpts[2]),
				    Math.max(ctrlpts[4],ctrlpts[6])) + 2;
	    int y2 = (int) Math.max(Math.max(ctrlpts[1],ctrlpts[3]),
				    Math.max(ctrlpts[5],ctrlpts[7])) + 2;
	    imagedst.doBezier(ctrlpts, d,
			      (float) Math.random(),
			      (float) Math.random(),
			      (float) Math.random());
	    Graphics g = getGraphics();
	    g.drawImage(img,
			x1, y1, x2, y2,
			x1, y1, x2, y2,
			null);
	    g.dispose();
	    for (int i = 0; i < 8; i += 2) {
		increment(ctrlpts, deltas, i, d.width);
		increment(ctrlpts, deltas, i + 1, d.height);
	    }
	    canvasdst.doBezier(ctrlpts, d, 1.0f, 1.0f, 1.0f);
	    try {wait(10);} catch (InterruptedException e) {return;}
	}
    }

    public void paint(Graphics g) {
	if (img != null) {
	    g.drawImage(img, 0, 0, null);
	}
    }
}

abstract class DrawSurfaceTracker {
    DrawingSurfaceInfo dsi;
    int dsistate;
    Rectangle dsibounds;
    Shape dsiclip;

    DrawSurfaceTracker(DrawingSurfaceInfo dsi) {
	this.dsi = dsi;
	dsistate = -1;
    }

    public abstract void drawBezier(DrawingSurfaceInfo dsi, int state,
				    float ctrlpts[],
				    float red, float green, float blue);

    void doBezier(float ctrlpts[], Dimension d,
		  float red, float green, float blue) {
	int state = dsi.lock();
	try {
	    if (state != dsistate) {
		System.out.println("new state");
	    }
	    Rectangle r = dsi.getBounds();
	    if (state == dsistate && !r.equals(dsibounds)) {
		System.err.println("DSI bounds changed, but state didn't!!!");
	    }
	    if (!r.getSize().equals(d)) {
		System.err.println("bounds dimension doesn't match "+
				   "Object's dimension!!!");
	    }
	    Shape s = dsi.getClip();
	    if (state == dsistate && !s.equals(dsiclip)) {
		System.err.println("DSI clip changed, but state didn't!!!");
	    }
	    if (!s.getBounds().getSize().equals(d))
	    {
		System.err.println("clip dimension doesn't match "+
				   "Component's dimension!!!");
	    }
	    drawBezier(dsi, state, ctrlpts, red, green, blue);
	    dsibounds = r;
	    dsiclip = s;
	    dsistate = state;
	} finally {
	    dsi.unlock();
	}
    }
}
