/*
 * @(#)BasherApplet.java	1.5 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.net.*;
import java.util.*;
import java.io.*;
import sun.hotjava.ui.EditorFrame;
import java.util.Random;

/**
 * An applet for testing HotJava. It simply generates random events
 * to random components while visiting random URLs. Only works in
 * HotJava.
 *
 * @version 	1.5, 11/23/96
 * @author 	Arthur van Hoff
 */
public class BasherApplet extends java.applet.Applet implements Runnable {
    Vector v = new Vector();
    int pause = 0;
    int speed = 300;
    DataInputStream in;
    Random generator;

    int r(int range) {
	return (int)(range * generator.nextDouble());
    }

    int r(int min, int max) {
	return r(max - min) + min;
    }

    Component pickComponent(Component top) {
	getComponents(v, top);
	Component c = (Component)v.elementAt(r(v.size()));
	v.setSize(0);
	return c;
    }

    void getComponents(Vector v, Component c) {
	if (c.isVisible()) {
	    v.addElement(c);
	    if (c instanceof Container) {
		Component list[] = ((Container)c).getComponents();
		for (int i = 0 ; i < list.length ; i++) {
		    getComponents(v, list[i]);
		}
	    }
	}
    }

    public void init() {
	String str = getParameter("speed");
	if (str != null) {
	    speed = Integer.parseInt(str);
	}

	long seed;
	str = getParameter("seed");
	if (str != null) {
	    seed = Long.parseLong(str);
	} else {
	    seed = System.currentTimeMillis();
	    System.out.println("Using seed: " + seed);
	}

	generator = new Random(seed);

	new Thread(this, "Basher").start();
    }

    public void run() {
	Container top = this;
	for (; top.getParent() != null ; top = top.getParent());

	while (true) {
	    try {
		Thread.sleep(speed + pause + r(speed));	
		pause = 0;
	    } catch (InterruptedException e) {
		return;
	    }

	    switch (r(50)) {
	      case 0:
		fakeResize((Frame)top);
		break;
	      case 1:
	      case 2:
	      case 3:
		fakeShow((EditorFrame)top);
		break;
	      case 4:
	      case 5:
	      case 6:
		fakeMenuBar(((Frame)top).getMenuBar());
		break;

	      default: {
		Component c = pickComponent(top);
		if (c instanceof Scrollbar) {
		    fakeScroll((Scrollbar)c);
		} else if (c instanceof TextField) {
		    fakeText((TextField)c);
		} else if (c instanceof Button) {
		    fakeAction((Button)c);
		} else {
		    fakeMouseDown(c);
		}
	    }
	    }
	}
    }

    void fakeShow(EditorFrame frm) {
	try {
	    if (in == null) {
		in = new DataInputStream(new URL(getCodeBase(), "urls.data").openStream());
	    }
	    for (int i = r(10) ; i-- > 0 ; in.readLine());
	    String str = in.readLine();
	    if (str != null) {
		// Don't use show document, it may not work after this
 		// applet is destroyed.
		frm.push(new URL(str), false);
		pause = speed*r(5,10);
	    } else {
		in.close();
		in = null;
	    }
	} catch (MalformedURLException e) {
	    e.printStackTrace();
	} catch (IOException e) {
	    in = null;
	    e.printStackTrace();
	}
    }

    void fakeResize(Frame frm) {
	Dimension d = frm.size();
	if (d.width < 100) {
	    d.width += r(5, 40);
	} else if (d.width > 600) {
	    d.width -= r(5, 40);
	} else {
	    d.width += r(-10, 10);
	}
	if (d.height < 100) {
	    d.height += r(5, 40);
	} else if (d.height > 600) {
	    d.height -= r(5, 40);
	} else {
	    d.height += r(-10, 10);
	}
	frm.resize(d.width, d.height);
	frm.validate();
    }

    void fakeScroll(Scrollbar sb) {
	int min = sb.getMinimum();
	int max = sb.getMaximum();
	int val = sb.getValue();
	int page = sb.getVisible();
	
	switch (r(15)) {
	case 0:
	    if (val-1 >= min) {
		sb.postEvent(new Event(sb, System.currentTimeMillis(),
				       Event.SCROLL_LINE_UP, 0, 0, 0, 0, 
				       new Integer(val-1)));
	    }
	    break;
	case 1:
	    if (val+1 <= max) {
		sb.postEvent(new Event(sb, System.currentTimeMillis(),
				       Event.SCROLL_LINE_DOWN, 0, 0, 0, 0, 
				       new Integer(val+1)));
	    }
	    break;
	case 2:
	case 3:
	case 4:
	    if (val-page >= min) {
		sb.postEvent(new Event(sb, System.currentTimeMillis(),
				       Event.SCROLL_PAGE_UP, 0, 0, 0, 0,
				       new Integer(val-page)));
	    }
	    break;
	case 5:
	case 6:
	case 7:
	    if (val+page <= max) {
		sb.postEvent(new Event(sb, System.currentTimeMillis(),
				       Event.SCROLL_PAGE_DOWN, 0, 0, 0, 0,
				       new Integer(val+page)));
	    }
	    break;
	default:
	    if (min < max) {
		sb.postEvent(new Event(sb, System.currentTimeMillis(),
				       Event.SCROLL_ABSOLUTE, 0, 0, 0, 0,
				       new Integer(min + r(max - min))));
	    }
	    break;
	}
    }

    void fakeMouseDown(Component c) {
	Dimension d = c.size();
	int x = r(d.width);
	int y = r(d.height);

	c.postEvent(new Event(c, System.currentTimeMillis(),
			      Event.MOUSE_DOWN, x, y,
			      0, 0, null));
	if (r(5) == 1) {
	    for (int i = r(10) ; i-- > 0 ; ) {
		x += r(-10, 10);
		y += r(-10, 10);
		c.postEvent(new Event(c, System.currentTimeMillis(),
					      Event.MOUSE_DRAG, x, y,
					      0, 0, null));
		try {
		    Thread.sleep(r(100));
		} catch (InterruptedException e) {
		    return;
		}
	    }
	}

	// Mouse Up
	c.postEvent(new Event(c, System.currentTimeMillis(),
			      Event.MOUSE_UP, x + r(-50, 50), y + r(-50, 50),
			      0, 0, null));
    }

    void fakeAction(Button btn) {
	btn.postEvent(new Event(btn, System.currentTimeMillis(),
			      Event.ACTION_EVENT, 0, 0, 0, 0, btn.getLabel()));
    }

    void fakeText(TextField fld) {
	fld.postEvent(new Event(fld, System.currentTimeMillis(),
			      Event.ACTION_EVENT, 0, 0, 0, 0, fld.getText()));
    }

    void fakeMenu(Menu m) {
	if (m != null) {
	    MenuItem item = m.getItem(r(m.countItems()));
	    if (item instanceof Menu) {
		fakeMenu((Menu)item);
	    } else {
		item.postEvent(new Event(item, System.currentTimeMillis(),
			      Event.ACTION_EVENT, 0, 0, 0, 0, item.getLabel()));
	    }
	}
    }

    void fakeMenuBar(MenuBar mb) {
	if (mb != null) {
	    fakeMenu(mb.getMenu(r(mb.countMenus() - 1) + 1));
	}
    }
}
