package util;

/**
 * Test for NotReadables
 *
 * Resources should be found, but should not be readable (like .class files).
 */

import java.io.*;

public class NotReadable extends Util implements Test {
    public NotReadable() {
    }

    private static void usage() {
	print("usage for NotReadable tests: <golden file>");
    }

    // this is the check to perform
    public void check() throws TestException {
	if (canFind(theKlass, theName)) {
	    if (isNotReadable(theKlass, theName)) {
		pass(theName+" found and not readable.");
	    } else {
		fail(theName+" found but is readable.");
	    }
	} else {
	    fail(theName+" could not be found.");
	}
    }

    // run this test with this arguments
    public void run(Class klass, String args[]) {
	if (args.length != 1) {
	    usage();
	    System.exit(1);
	}
	String fileName = args[0];
	try {
	    BufferedReader r = null;
	    try {
		r = new BufferedReader(new FileReader(fileName));
	    } catch (Exception ex) {
		usage();
		System.exit(1);
	    }
	    String line;
	    // Get and print the test description
	    debug("class: "+klass);
	    debug("ClassLoader: "+klass.getClassLoader());
	    debug("CurrentClassLoader: "+myCurrentClassLoader());
	    while (((line = r.readLine()) != null) &&
		   (line.length() != 0)) {
		print2(line);
	    }
	    // parse the resource names and test them.
	    String name;
	    while ((name = r.readLine()) != null) {
		theKlass = klass;
		theName = name;
		indirect(klass);
	    }
	} catch (Exception ex) {
	    fail("Caught "+ex);
	}
	reportTest();
    }

    // The arguments (this is a closure)
    Class theKlass;		// the class providing the context
    String theName;		// the name of the resource
}
