package util;

/**
 * Test for Positives
 *
 * Resources should be found, readable, and reading as Stream should yield
 * the same as reading via URL.getContent.
 */

import java.io.*;

public class Positive extends Util implements Test {
    public Positive() {
    }

    private static void usage() {
	print("usage for Positive tests: <golden file>");
    }

    // this is the check to perform
    public void check() throws TestException {
	// Just ignore the argument
	if (canFind(theKlass, theName)) {
	    if (isReadable(theKlass, theName)) {
		pass(theName+" found and readable.");
	    } else {
		fail(theName+" found but not readable.");
	    }
	} else {
	    fail(theName+" not found.");
	}
    }

    // run this test with this arguments
    public void run(Class klass, String args[]) {
	if (args.length != 1) {
	    usage();
	    System.exit(1);
	}
	String fileName = args[0];
	try {
	    BufferedReader r = null;
	    try {
		r = new BufferedReader(new FileReader(fileName));
	    } catch (Exception ex) {
		usage();
		System.exit(1);
	    }
	    String line;
	    // Get and print the test description
	    debug("class: "+klass);
	    debug("ClassLoader: "+klass.getClassLoader());
	    debug("CurrentClassLoader: "+myCurrentClassLoader());
	    if (getDebug()) {
		debug("Printing class context");
		printClassContext();
	    }
	    while (((line = r.readLine()) != null) &&
		   (line.length() != 0)) {
		print2(line);
	    }
	    String name;
	    while ((name = r.readLine()) != null) {
		theKlass = klass;
		theName = name;
		indirect(klass);
	    }
	} catch (Exception ex) {
	    fail("Caught "+ex);
	}
	reportTest();
    }

    // The arguments (this is a closure)
    Class theKlass;		// the class providing the context
    String theName;		// the name of the resource
}
